/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.ModifierLocationOverrides;
import com.squareup.square.models.Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class CatalogModifier {
    private final OptionalNullable<String> name;
    private final Money priceMoney;
    private final OptionalNullable<Integer> ordinal;
    private final OptionalNullable<String> modifierListId;
    private final OptionalNullable<List<ModifierLocationOverrides>> locationOverrides;
    private final OptionalNullable<String> imageId;

    @JsonCreator
    public CatalogModifier(@JsonProperty(value="name") String name, @JsonProperty(value="price_money") Money priceMoney, @JsonProperty(value="ordinal") Integer ordinal, @JsonProperty(value="modifier_list_id") String modifierListId, @JsonProperty(value="location_overrides") List<ModifierLocationOverrides> locationOverrides, @JsonProperty(value="image_id") String imageId) {
        this.name = OptionalNullable.of((Object)name);
        this.priceMoney = priceMoney;
        this.ordinal = OptionalNullable.of((Object)ordinal);
        this.modifierListId = OptionalNullable.of((Object)modifierListId);
        this.locationOverrides = OptionalNullable.of(locationOverrides);
        this.imageId = OptionalNullable.of((Object)imageId);
    }

    protected CatalogModifier(OptionalNullable<String> name, Money priceMoney, OptionalNullable<Integer> ordinal, OptionalNullable<String> modifierListId, OptionalNullable<List<ModifierLocationOverrides>> locationOverrides, OptionalNullable<String> imageId) {
        this.name = name;
        this.priceMoney = priceMoney;
        this.ordinal = ordinal;
        this.modifierListId = modifierListId;
        this.locationOverrides = locationOverrides;
        this.imageId = imageId;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetName() {
        return this.name;
    }

    @JsonIgnore
    public String getName() {
        return (String)OptionalNullable.getFrom(this.name);
    }

    @JsonGetter(value="price_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getPriceMoney() {
        return this.priceMoney;
    }

    @JsonGetter(value="ordinal")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Integer> internalGetOrdinal() {
        return this.ordinal;
    }

    @JsonIgnore
    public Integer getOrdinal() {
        return (Integer)OptionalNullable.getFrom(this.ordinal);
    }

    @JsonGetter(value="modifier_list_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetModifierListId() {
        return this.modifierListId;
    }

    @JsonIgnore
    public String getModifierListId() {
        return (String)OptionalNullable.getFrom(this.modifierListId);
    }

    @JsonGetter(value="location_overrides")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<ModifierLocationOverrides>> internalGetLocationOverrides() {
        return this.locationOverrides;
    }

    @JsonIgnore
    public List<ModifierLocationOverrides> getLocationOverrides() {
        return (List)OptionalNullable.getFrom(this.locationOverrides);
    }

    @JsonGetter(value="image_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetImageId() {
        return this.imageId;
    }

    @JsonIgnore
    public String getImageId() {
        return (String)OptionalNullable.getFrom(this.imageId);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.priceMoney, this.ordinal, this.modifierListId, this.locationOverrides, this.imageId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogModifier)) {
            return false;
        }
        CatalogModifier other = (CatalogModifier)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.priceMoney, other.priceMoney) && Objects.equals(this.ordinal, other.ordinal) && Objects.equals(this.modifierListId, other.modifierListId) && Objects.equals(this.locationOverrides, other.locationOverrides) && Objects.equals(this.imageId, other.imageId);
    }

    public String toString() {
        return "CatalogModifier [name=" + this.name + ", priceMoney=" + this.priceMoney + ", ordinal=" + this.ordinal + ", modifierListId=" + this.modifierListId + ", locationOverrides=" + this.locationOverrides + ", imageId=" + this.imageId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().priceMoney(this.getPriceMoney());
        builder.name = this.internalGetName();
        builder.ordinal = this.internalGetOrdinal();
        builder.modifierListId = this.internalGetModifierListId();
        builder.locationOverrides = this.internalGetLocationOverrides();
        builder.imageId = this.internalGetImageId();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> name;
        private Money priceMoney;
        private OptionalNullable<Integer> ordinal;
        private OptionalNullable<String> modifierListId;
        private OptionalNullable<List<ModifierLocationOverrides>> locationOverrides;
        private OptionalNullable<String> imageId;

        public Builder name(String name) {
            this.name = OptionalNullable.of((Object)name);
            return this;
        }

        public Builder unsetName() {
            this.name = null;
            return this;
        }

        public Builder priceMoney(Money priceMoney) {
            this.priceMoney = priceMoney;
            return this;
        }

        public Builder ordinal(Integer ordinal) {
            this.ordinal = OptionalNullable.of((Object)ordinal);
            return this;
        }

        public Builder unsetOrdinal() {
            this.ordinal = null;
            return this;
        }

        public Builder modifierListId(String modifierListId) {
            this.modifierListId = OptionalNullable.of((Object)modifierListId);
            return this;
        }

        public Builder unsetModifierListId() {
            this.modifierListId = null;
            return this;
        }

        public Builder locationOverrides(List<ModifierLocationOverrides> locationOverrides) {
            this.locationOverrides = OptionalNullable.of(locationOverrides);
            return this;
        }

        public Builder unsetLocationOverrides() {
            this.locationOverrides = null;
            return this;
        }

        public Builder imageId(String imageId) {
            this.imageId = OptionalNullable.of((Object)imageId);
            return this;
        }

        public Builder unsetImageId() {
            this.imageId = null;
            return this;
        }

        public CatalogModifier build() {
            return new CatalogModifier(this.name, this.priceMoney, this.ordinal, this.modifierListId, this.locationOverrides, this.imageId);
        }
    }
}

