/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.CatalogObject;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class CatalogModifierList {
    private final OptionalNullable<String> name;
    private final OptionalNullable<Integer> ordinal;
    private final String selectionType;
    private final OptionalNullable<List<CatalogObject>> modifiers;
    private final OptionalNullable<List<String>> imageIds;

    @JsonCreator
    public CatalogModifierList(@JsonProperty(value="name") String name, @JsonProperty(value="ordinal") Integer ordinal, @JsonProperty(value="selection_type") String selectionType, @JsonProperty(value="modifiers") List<CatalogObject> modifiers, @JsonProperty(value="image_ids") List<String> imageIds) {
        this.name = OptionalNullable.of((Object)name);
        this.ordinal = OptionalNullable.of((Object)ordinal);
        this.selectionType = selectionType;
        this.modifiers = OptionalNullable.of(modifiers);
        this.imageIds = OptionalNullable.of(imageIds);
    }

    protected CatalogModifierList(OptionalNullable<String> name, OptionalNullable<Integer> ordinal, String selectionType, OptionalNullable<List<CatalogObject>> modifiers, OptionalNullable<List<String>> imageIds) {
        this.name = name;
        this.ordinal = ordinal;
        this.selectionType = selectionType;
        this.modifiers = modifiers;
        this.imageIds = imageIds;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetName() {
        return this.name;
    }

    @JsonIgnore
    public String getName() {
        return (String)OptionalNullable.getFrom(this.name);
    }

    @JsonGetter(value="ordinal")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Integer> internalGetOrdinal() {
        return this.ordinal;
    }

    @JsonIgnore
    public Integer getOrdinal() {
        return (Integer)OptionalNullable.getFrom(this.ordinal);
    }

    @JsonGetter(value="selection_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSelectionType() {
        return this.selectionType;
    }

    @JsonGetter(value="modifiers")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<CatalogObject>> internalGetModifiers() {
        return this.modifiers;
    }

    @JsonIgnore
    public List<CatalogObject> getModifiers() {
        return (List)OptionalNullable.getFrom(this.modifiers);
    }

    @JsonGetter(value="image_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetImageIds() {
        return this.imageIds;
    }

    @JsonIgnore
    public List<String> getImageIds() {
        return (List)OptionalNullable.getFrom(this.imageIds);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.ordinal, this.selectionType, this.modifiers, this.imageIds);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogModifierList)) {
            return false;
        }
        CatalogModifierList other = (CatalogModifierList)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.ordinal, other.ordinal) && Objects.equals(this.selectionType, other.selectionType) && Objects.equals(this.modifiers, other.modifiers) && Objects.equals(this.imageIds, other.imageIds);
    }

    public String toString() {
        return "CatalogModifierList [name=" + this.name + ", ordinal=" + this.ordinal + ", selectionType=" + this.selectionType + ", modifiers=" + this.modifiers + ", imageIds=" + this.imageIds + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().selectionType(this.getSelectionType());
        builder.name = this.internalGetName();
        builder.ordinal = this.internalGetOrdinal();
        builder.modifiers = this.internalGetModifiers();
        builder.imageIds = this.internalGetImageIds();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> name;
        private OptionalNullable<Integer> ordinal;
        private String selectionType;
        private OptionalNullable<List<CatalogObject>> modifiers;
        private OptionalNullable<List<String>> imageIds;

        public Builder name(String name) {
            this.name = OptionalNullable.of((Object)name);
            return this;
        }

        public Builder unsetName() {
            this.name = null;
            return this;
        }

        public Builder ordinal(Integer ordinal) {
            this.ordinal = OptionalNullable.of((Object)ordinal);
            return this;
        }

        public Builder unsetOrdinal() {
            this.ordinal = null;
            return this;
        }

        public Builder selectionType(String selectionType) {
            this.selectionType = selectionType;
            return this;
        }

        public Builder modifiers(List<CatalogObject> modifiers) {
            this.modifiers = OptionalNullable.of(modifiers);
            return this;
        }

        public Builder unsetModifiers() {
            this.modifiers = null;
            return this;
        }

        public Builder imageIds(List<String> imageIds) {
            this.imageIds = OptionalNullable.of(imageIds);
            return this;
        }

        public Builder unsetImageIds() {
            this.imageIds = null;
            return this;
        }

        public CatalogModifierList build() {
            return new CatalogModifierList(this.name, this.ordinal, this.selectionType, this.modifiers, this.imageIds);
        }
    }
}

