/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class CatalogModifierOverride {
    private final String modifierId;
    private final OptionalNullable<Boolean> onByDefault;

    @JsonCreator
    public CatalogModifierOverride(@JsonProperty(value="modifier_id") String modifierId, @JsonProperty(value="on_by_default") Boolean onByDefault) {
        this.modifierId = modifierId;
        this.onByDefault = OptionalNullable.of((Object)onByDefault);
    }

    protected CatalogModifierOverride(String modifierId, OptionalNullable<Boolean> onByDefault) {
        this.modifierId = modifierId;
        this.onByDefault = onByDefault;
    }

    @JsonGetter(value="modifier_id")
    public String getModifierId() {
        return this.modifierId;
    }

    @JsonGetter(value="on_by_default")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetOnByDefault() {
        return this.onByDefault;
    }

    @JsonIgnore
    public Boolean getOnByDefault() {
        return (Boolean)OptionalNullable.getFrom(this.onByDefault);
    }

    public int hashCode() {
        return Objects.hash(this.modifierId, this.onByDefault);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogModifierOverride)) {
            return false;
        }
        CatalogModifierOverride other = (CatalogModifierOverride)obj;
        return Objects.equals(this.modifierId, other.modifierId) && Objects.equals(this.onByDefault, other.onByDefault);
    }

    public String toString() {
        return "CatalogModifierOverride [modifierId=" + this.modifierId + ", onByDefault=" + this.onByDefault + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.modifierId);
        builder.onByDefault = this.internalGetOnByDefault();
        return builder;
    }

    public static class Builder {
        private String modifierId;
        private OptionalNullable<Boolean> onByDefault;

        public Builder(String modifierId) {
            this.modifierId = modifierId;
        }

        public Builder modifierId(String modifierId) {
            this.modifierId = modifierId;
            return this;
        }

        public Builder onByDefault(Boolean onByDefault) {
            this.onByDefault = OptionalNullable.of((Object)onByDefault);
            return this;
        }

        public Builder unsetOnByDefault() {
            this.onByDefault = null;
            return this;
        }

        public CatalogModifierOverride build() {
            return new CatalogModifierOverride(this.modifierId, this.onByDefault);
        }
    }
}

