/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class CatalogObjectCategory {
    private final String id;
    private final OptionalNullable<Long> ordinal;

    @JsonCreator
    public CatalogObjectCategory(@JsonProperty(value="id") String id, @JsonProperty(value="ordinal") Long ordinal) {
        this.id = id;
        this.ordinal = OptionalNullable.of((Object)ordinal);
    }

    protected CatalogObjectCategory(String id, OptionalNullable<Long> ordinal) {
        this.id = id;
        this.ordinal = ordinal;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="ordinal")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Long> internalGetOrdinal() {
        return this.ordinal;
    }

    @JsonIgnore
    public Long getOrdinal() {
        return (Long)OptionalNullable.getFrom(this.ordinal);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.ordinal);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogObjectCategory)) {
            return false;
        }
        CatalogObjectCategory other = (CatalogObjectCategory)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.ordinal, other.ordinal);
    }

    public String toString() {
        return "CatalogObjectCategory [id=" + this.id + ", ordinal=" + this.ordinal + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId());
        builder.ordinal = this.internalGetOrdinal();
        return builder;
    }

    public static class Builder {
        private String id;
        private OptionalNullable<Long> ordinal;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder ordinal(Long ordinal) {
            this.ordinal = OptionalNullable.of((Object)ordinal);
            return this;
        }

        public Builder unsetOrdinal() {
            this.ordinal = null;
            return this;
        }

        public CatalogObjectCategory build() {
            return new CatalogObjectCategory(this.id, this.ordinal);
        }
    }
}

