/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.CatalogQueryExact;
import com.squareup.square.models.CatalogQueryItemVariationsForItemOptionValues;
import com.squareup.square.models.CatalogQueryItemsForItemOptions;
import com.squareup.square.models.CatalogQueryItemsForModifierList;
import com.squareup.square.models.CatalogQueryItemsForTax;
import com.squareup.square.models.CatalogQueryPrefix;
import com.squareup.square.models.CatalogQueryRange;
import com.squareup.square.models.CatalogQuerySet;
import com.squareup.square.models.CatalogQuerySortedAttribute;
import com.squareup.square.models.CatalogQueryText;
import java.util.Objects;

public class CatalogQuery {
    private final CatalogQuerySortedAttribute sortedAttributeQuery;
    private final CatalogQueryExact exactQuery;
    private final CatalogQuerySet setQuery;
    private final CatalogQueryPrefix prefixQuery;
    private final CatalogQueryRange rangeQuery;
    private final CatalogQueryText textQuery;
    private final CatalogQueryItemsForTax itemsForTaxQuery;
    private final CatalogQueryItemsForModifierList itemsForModifierListQuery;
    private final CatalogQueryItemsForItemOptions itemsForItemOptionsQuery;
    private final CatalogQueryItemVariationsForItemOptionValues itemVariationsForItemOptionValuesQuery;

    @JsonCreator
    public CatalogQuery(@JsonProperty(value="sorted_attribute_query") CatalogQuerySortedAttribute sortedAttributeQuery, @JsonProperty(value="exact_query") CatalogQueryExact exactQuery, @JsonProperty(value="set_query") CatalogQuerySet setQuery, @JsonProperty(value="prefix_query") CatalogQueryPrefix prefixQuery, @JsonProperty(value="range_query") CatalogQueryRange rangeQuery, @JsonProperty(value="text_query") CatalogQueryText textQuery, @JsonProperty(value="items_for_tax_query") CatalogQueryItemsForTax itemsForTaxQuery, @JsonProperty(value="items_for_modifier_list_query") CatalogQueryItemsForModifierList itemsForModifierListQuery, @JsonProperty(value="items_for_item_options_query") CatalogQueryItemsForItemOptions itemsForItemOptionsQuery, @JsonProperty(value="item_variations_for_item_option_values_query") CatalogQueryItemVariationsForItemOptionValues itemVariationsForItemOptionValuesQuery) {
        this.sortedAttributeQuery = sortedAttributeQuery;
        this.exactQuery = exactQuery;
        this.setQuery = setQuery;
        this.prefixQuery = prefixQuery;
        this.rangeQuery = rangeQuery;
        this.textQuery = textQuery;
        this.itemsForTaxQuery = itemsForTaxQuery;
        this.itemsForModifierListQuery = itemsForModifierListQuery;
        this.itemsForItemOptionsQuery = itemsForItemOptionsQuery;
        this.itemVariationsForItemOptionValuesQuery = itemVariationsForItemOptionValuesQuery;
    }

    @JsonGetter(value="sorted_attribute_query")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CatalogQuerySortedAttribute getSortedAttributeQuery() {
        return this.sortedAttributeQuery;
    }

    @JsonGetter(value="exact_query")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CatalogQueryExact getExactQuery() {
        return this.exactQuery;
    }

    @JsonGetter(value="set_query")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CatalogQuerySet getSetQuery() {
        return this.setQuery;
    }

    @JsonGetter(value="prefix_query")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CatalogQueryPrefix getPrefixQuery() {
        return this.prefixQuery;
    }

    @JsonGetter(value="range_query")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CatalogQueryRange getRangeQuery() {
        return this.rangeQuery;
    }

    @JsonGetter(value="text_query")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CatalogQueryText getTextQuery() {
        return this.textQuery;
    }

    @JsonGetter(value="items_for_tax_query")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CatalogQueryItemsForTax getItemsForTaxQuery() {
        return this.itemsForTaxQuery;
    }

    @JsonGetter(value="items_for_modifier_list_query")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CatalogQueryItemsForModifierList getItemsForModifierListQuery() {
        return this.itemsForModifierListQuery;
    }

    @JsonGetter(value="items_for_item_options_query")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CatalogQueryItemsForItemOptions getItemsForItemOptionsQuery() {
        return this.itemsForItemOptionsQuery;
    }

    @JsonGetter(value="item_variations_for_item_option_values_query")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CatalogQueryItemVariationsForItemOptionValues getItemVariationsForItemOptionValuesQuery() {
        return this.itemVariationsForItemOptionValuesQuery;
    }

    public int hashCode() {
        return Objects.hash(this.sortedAttributeQuery, this.exactQuery, this.setQuery, this.prefixQuery, this.rangeQuery, this.textQuery, this.itemsForTaxQuery, this.itemsForModifierListQuery, this.itemsForItemOptionsQuery, this.itemVariationsForItemOptionValuesQuery);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogQuery)) {
            return false;
        }
        CatalogQuery other = (CatalogQuery)obj;
        return Objects.equals(this.sortedAttributeQuery, other.sortedAttributeQuery) && Objects.equals(this.exactQuery, other.exactQuery) && Objects.equals(this.setQuery, other.setQuery) && Objects.equals(this.prefixQuery, other.prefixQuery) && Objects.equals(this.rangeQuery, other.rangeQuery) && Objects.equals(this.textQuery, other.textQuery) && Objects.equals(this.itemsForTaxQuery, other.itemsForTaxQuery) && Objects.equals(this.itemsForModifierListQuery, other.itemsForModifierListQuery) && Objects.equals(this.itemsForItemOptionsQuery, other.itemsForItemOptionsQuery) && Objects.equals(this.itemVariationsForItemOptionValuesQuery, other.itemVariationsForItemOptionValuesQuery);
    }

    public String toString() {
        return "CatalogQuery [sortedAttributeQuery=" + this.sortedAttributeQuery + ", exactQuery=" + this.exactQuery + ", setQuery=" + this.setQuery + ", prefixQuery=" + this.prefixQuery + ", rangeQuery=" + this.rangeQuery + ", textQuery=" + this.textQuery + ", itemsForTaxQuery=" + this.itemsForTaxQuery + ", itemsForModifierListQuery=" + this.itemsForModifierListQuery + ", itemsForItemOptionsQuery=" + this.itemsForItemOptionsQuery + ", itemVariationsForItemOptionValuesQuery=" + this.itemVariationsForItemOptionValuesQuery + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().sortedAttributeQuery(this.getSortedAttributeQuery()).exactQuery(this.getExactQuery()).setQuery(this.getSetQuery()).prefixQuery(this.getPrefixQuery()).rangeQuery(this.getRangeQuery()).textQuery(this.getTextQuery()).itemsForTaxQuery(this.getItemsForTaxQuery()).itemsForModifierListQuery(this.getItemsForModifierListQuery()).itemsForItemOptionsQuery(this.getItemsForItemOptionsQuery()).itemVariationsForItemOptionValuesQuery(this.getItemVariationsForItemOptionValuesQuery());
        return builder;
    }

    public static class Builder {
        private CatalogQuerySortedAttribute sortedAttributeQuery;
        private CatalogQueryExact exactQuery;
        private CatalogQuerySet setQuery;
        private CatalogQueryPrefix prefixQuery;
        private CatalogQueryRange rangeQuery;
        private CatalogQueryText textQuery;
        private CatalogQueryItemsForTax itemsForTaxQuery;
        private CatalogQueryItemsForModifierList itemsForModifierListQuery;
        private CatalogQueryItemsForItemOptions itemsForItemOptionsQuery;
        private CatalogQueryItemVariationsForItemOptionValues itemVariationsForItemOptionValuesQuery;

        public Builder sortedAttributeQuery(CatalogQuerySortedAttribute sortedAttributeQuery) {
            this.sortedAttributeQuery = sortedAttributeQuery;
            return this;
        }

        public Builder exactQuery(CatalogQueryExact exactQuery) {
            this.exactQuery = exactQuery;
            return this;
        }

        public Builder setQuery(CatalogQuerySet setQuery) {
            this.setQuery = setQuery;
            return this;
        }

        public Builder prefixQuery(CatalogQueryPrefix prefixQuery) {
            this.prefixQuery = prefixQuery;
            return this;
        }

        public Builder rangeQuery(CatalogQueryRange rangeQuery) {
            this.rangeQuery = rangeQuery;
            return this;
        }

        public Builder textQuery(CatalogQueryText textQuery) {
            this.textQuery = textQuery;
            return this;
        }

        public Builder itemsForTaxQuery(CatalogQueryItemsForTax itemsForTaxQuery) {
            this.itemsForTaxQuery = itemsForTaxQuery;
            return this;
        }

        public Builder itemsForModifierListQuery(CatalogQueryItemsForModifierList itemsForModifierListQuery) {
            this.itemsForModifierListQuery = itemsForModifierListQuery;
            return this;
        }

        public Builder itemsForItemOptionsQuery(CatalogQueryItemsForItemOptions itemsForItemOptionsQuery) {
            this.itemsForItemOptionsQuery = itemsForItemOptionsQuery;
            return this;
        }

        public Builder itemVariationsForItemOptionValuesQuery(CatalogQueryItemVariationsForItemOptionValues itemVariationsForItemOptionValuesQuery) {
            this.itemVariationsForItemOptionValuesQuery = itemVariationsForItemOptionValuesQuery;
            return this;
        }

        public CatalogQuery build() {
            return new CatalogQuery(this.sortedAttributeQuery, this.exactQuery, this.setQuery, this.prefixQuery, this.rangeQuery, this.textQuery, this.itemsForTaxQuery, this.itemsForModifierListQuery, this.itemsForItemOptionsQuery, this.itemVariationsForItemOptionValuesQuery);
        }
    }
}

