/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class CatalogQueryRange {
    private final String attributeName;
    private final OptionalNullable<Long> attributeMinValue;
    private final OptionalNullable<Long> attributeMaxValue;

    @JsonCreator
    public CatalogQueryRange(@JsonProperty(value="attribute_name") String attributeName, @JsonProperty(value="attribute_min_value") Long attributeMinValue, @JsonProperty(value="attribute_max_value") Long attributeMaxValue) {
        this.attributeName = attributeName;
        this.attributeMinValue = OptionalNullable.of((Object)attributeMinValue);
        this.attributeMaxValue = OptionalNullable.of((Object)attributeMaxValue);
    }

    protected CatalogQueryRange(String attributeName, OptionalNullable<Long> attributeMinValue, OptionalNullable<Long> attributeMaxValue) {
        this.attributeName = attributeName;
        this.attributeMinValue = attributeMinValue;
        this.attributeMaxValue = attributeMaxValue;
    }

    @JsonGetter(value="attribute_name")
    public String getAttributeName() {
        return this.attributeName;
    }

    @JsonGetter(value="attribute_min_value")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Long> internalGetAttributeMinValue() {
        return this.attributeMinValue;
    }

    @JsonIgnore
    public Long getAttributeMinValue() {
        return (Long)OptionalNullable.getFrom(this.attributeMinValue);
    }

    @JsonGetter(value="attribute_max_value")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Long> internalGetAttributeMaxValue() {
        return this.attributeMaxValue;
    }

    @JsonIgnore
    public Long getAttributeMaxValue() {
        return (Long)OptionalNullable.getFrom(this.attributeMaxValue);
    }

    public int hashCode() {
        return Objects.hash(this.attributeName, this.attributeMinValue, this.attributeMaxValue);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogQueryRange)) {
            return false;
        }
        CatalogQueryRange other = (CatalogQueryRange)obj;
        return Objects.equals(this.attributeName, other.attributeName) && Objects.equals(this.attributeMinValue, other.attributeMinValue) && Objects.equals(this.attributeMaxValue, other.attributeMaxValue);
    }

    public String toString() {
        return "CatalogQueryRange [attributeName=" + this.attributeName + ", attributeMinValue=" + this.attributeMinValue + ", attributeMaxValue=" + this.attributeMaxValue + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.attributeName);
        builder.attributeMinValue = this.internalGetAttributeMinValue();
        builder.attributeMaxValue = this.internalGetAttributeMaxValue();
        return builder;
    }

    public static class Builder {
        private String attributeName;
        private OptionalNullable<Long> attributeMinValue;
        private OptionalNullable<Long> attributeMaxValue;

        public Builder(String attributeName) {
            this.attributeName = attributeName;
        }

        public Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public Builder attributeMinValue(Long attributeMinValue) {
            this.attributeMinValue = OptionalNullable.of((Object)attributeMinValue);
            return this;
        }

        public Builder unsetAttributeMinValue() {
            this.attributeMinValue = null;
            return this;
        }

        public Builder attributeMaxValue(Long attributeMaxValue) {
            this.attributeMaxValue = OptionalNullable.of((Object)attributeMaxValue);
            return this;
        }

        public Builder unsetAttributeMaxValue() {
            this.attributeMaxValue = null;
            return this;
        }

        public CatalogQueryRange build() {
            return new CatalogQueryRange(this.attributeName, this.attributeMinValue, this.attributeMaxValue);
        }
    }
}

