/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.CatalogQuickAmount;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class CatalogQuickAmountsSettings {
    private final String option;
    private final OptionalNullable<Boolean> eligibleForAutoAmounts;
    private final OptionalNullable<List<CatalogQuickAmount>> amounts;

    @JsonCreator
    public CatalogQuickAmountsSettings(@JsonProperty(value="option") String option, @JsonProperty(value="eligible_for_auto_amounts") Boolean eligibleForAutoAmounts, @JsonProperty(value="amounts") List<CatalogQuickAmount> amounts) {
        this.option = option;
        this.eligibleForAutoAmounts = OptionalNullable.of((Object)eligibleForAutoAmounts);
        this.amounts = OptionalNullable.of(amounts);
    }

    protected CatalogQuickAmountsSettings(String option, OptionalNullable<Boolean> eligibleForAutoAmounts, OptionalNullable<List<CatalogQuickAmount>> amounts) {
        this.option = option;
        this.eligibleForAutoAmounts = eligibleForAutoAmounts;
        this.amounts = amounts;
    }

    @JsonGetter(value="option")
    public String getOption() {
        return this.option;
    }

    @JsonGetter(value="eligible_for_auto_amounts")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetEligibleForAutoAmounts() {
        return this.eligibleForAutoAmounts;
    }

    @JsonIgnore
    public Boolean getEligibleForAutoAmounts() {
        return (Boolean)OptionalNullable.getFrom(this.eligibleForAutoAmounts);
    }

    @JsonGetter(value="amounts")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<CatalogQuickAmount>> internalGetAmounts() {
        return this.amounts;
    }

    @JsonIgnore
    public List<CatalogQuickAmount> getAmounts() {
        return (List)OptionalNullable.getFrom(this.amounts);
    }

    public int hashCode() {
        return Objects.hash(this.option, this.eligibleForAutoAmounts, this.amounts);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogQuickAmountsSettings)) {
            return false;
        }
        CatalogQuickAmountsSettings other = (CatalogQuickAmountsSettings)obj;
        return Objects.equals(this.option, other.option) && Objects.equals(this.eligibleForAutoAmounts, other.eligibleForAutoAmounts) && Objects.equals(this.amounts, other.amounts);
    }

    public String toString() {
        return "CatalogQuickAmountsSettings [option=" + this.option + ", eligibleForAutoAmounts=" + this.eligibleForAutoAmounts + ", amounts=" + this.amounts + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.option);
        builder.eligibleForAutoAmounts = this.internalGetEligibleForAutoAmounts();
        builder.amounts = this.internalGetAmounts();
        return builder;
    }

    public static class Builder {
        private String option;
        private OptionalNullable<Boolean> eligibleForAutoAmounts;
        private OptionalNullable<List<CatalogQuickAmount>> amounts;

        public Builder(String option) {
            this.option = option;
        }

        public Builder option(String option) {
            this.option = option;
            return this;
        }

        public Builder eligibleForAutoAmounts(Boolean eligibleForAutoAmounts) {
            this.eligibleForAutoAmounts = OptionalNullable.of((Object)eligibleForAutoAmounts);
            return this;
        }

        public Builder unsetEligibleForAutoAmounts() {
            this.eligibleForAutoAmounts = null;
            return this;
        }

        public Builder amounts(List<CatalogQuickAmount> amounts) {
            this.amounts = OptionalNullable.of(amounts);
            return this;
        }

        public Builder unsetAmounts() {
            this.amounts = null;
            return this;
        }

        public CatalogQuickAmountsSettings build() {
            return new CatalogQuickAmountsSettings(this.option, this.eligibleForAutoAmounts, this.amounts);
        }
    }
}

