/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.SubscriptionPhase;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class CatalogSubscriptionPlanVariation {
    private final String name;
    private final List<SubscriptionPhase> phases;
    private final OptionalNullable<String> subscriptionPlanId;
    private final OptionalNullable<Long> monthlyBillingAnchorDate;
    private final OptionalNullable<Boolean> canProrate;
    private final OptionalNullable<String> successorPlanVariationId;

    @JsonCreator
    public CatalogSubscriptionPlanVariation(@JsonProperty(value="name") String name, @JsonProperty(value="phases") List<SubscriptionPhase> phases, @JsonProperty(value="subscription_plan_id") String subscriptionPlanId, @JsonProperty(value="monthly_billing_anchor_date") Long monthlyBillingAnchorDate, @JsonProperty(value="can_prorate") Boolean canProrate, @JsonProperty(value="successor_plan_variation_id") String successorPlanVariationId) {
        this.name = name;
        this.phases = phases;
        this.subscriptionPlanId = OptionalNullable.of((Object)subscriptionPlanId);
        this.monthlyBillingAnchorDate = OptionalNullable.of((Object)monthlyBillingAnchorDate);
        this.canProrate = OptionalNullable.of((Object)canProrate);
        this.successorPlanVariationId = OptionalNullable.of((Object)successorPlanVariationId);
    }

    protected CatalogSubscriptionPlanVariation(String name, List<SubscriptionPhase> phases, OptionalNullable<String> subscriptionPlanId, OptionalNullable<Long> monthlyBillingAnchorDate, OptionalNullable<Boolean> canProrate, OptionalNullable<String> successorPlanVariationId) {
        this.name = name;
        this.phases = phases;
        this.subscriptionPlanId = subscriptionPlanId;
        this.monthlyBillingAnchorDate = monthlyBillingAnchorDate;
        this.canProrate = canProrate;
        this.successorPlanVariationId = successorPlanVariationId;
    }

    @JsonGetter(value="name")
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="phases")
    public List<SubscriptionPhase> getPhases() {
        return this.phases;
    }

    @JsonGetter(value="subscription_plan_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetSubscriptionPlanId() {
        return this.subscriptionPlanId;
    }

    @JsonIgnore
    public String getSubscriptionPlanId() {
        return (String)OptionalNullable.getFrom(this.subscriptionPlanId);
    }

    @JsonGetter(value="monthly_billing_anchor_date")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Long> internalGetMonthlyBillingAnchorDate() {
        return this.monthlyBillingAnchorDate;
    }

    @JsonIgnore
    public Long getMonthlyBillingAnchorDate() {
        return (Long)OptionalNullable.getFrom(this.monthlyBillingAnchorDate);
    }

    @JsonGetter(value="can_prorate")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetCanProrate() {
        return this.canProrate;
    }

    @JsonIgnore
    public Boolean getCanProrate() {
        return (Boolean)OptionalNullable.getFrom(this.canProrate);
    }

    @JsonGetter(value="successor_plan_variation_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetSuccessorPlanVariationId() {
        return this.successorPlanVariationId;
    }

    @JsonIgnore
    public String getSuccessorPlanVariationId() {
        return (String)OptionalNullable.getFrom(this.successorPlanVariationId);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.phases, this.subscriptionPlanId, this.monthlyBillingAnchorDate, this.canProrate, this.successorPlanVariationId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogSubscriptionPlanVariation)) {
            return false;
        }
        CatalogSubscriptionPlanVariation other = (CatalogSubscriptionPlanVariation)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.phases, other.phases) && Objects.equals(this.subscriptionPlanId, other.subscriptionPlanId) && Objects.equals(this.monthlyBillingAnchorDate, other.monthlyBillingAnchorDate) && Objects.equals(this.canProrate, other.canProrate) && Objects.equals(this.successorPlanVariationId, other.successorPlanVariationId);
    }

    public String toString() {
        return "CatalogSubscriptionPlanVariation [name=" + this.name + ", phases=" + this.phases + ", subscriptionPlanId=" + this.subscriptionPlanId + ", monthlyBillingAnchorDate=" + this.monthlyBillingAnchorDate + ", canProrate=" + this.canProrate + ", successorPlanVariationId=" + this.successorPlanVariationId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.name, this.phases);
        builder.subscriptionPlanId = this.internalGetSubscriptionPlanId();
        builder.monthlyBillingAnchorDate = this.internalGetMonthlyBillingAnchorDate();
        builder.canProrate = this.internalGetCanProrate();
        builder.successorPlanVariationId = this.internalGetSuccessorPlanVariationId();
        return builder;
    }

    public static class Builder {
        private String name;
        private List<SubscriptionPhase> phases;
        private OptionalNullable<String> subscriptionPlanId;
        private OptionalNullable<Long> monthlyBillingAnchorDate;
        private OptionalNullable<Boolean> canProrate;
        private OptionalNullable<String> successorPlanVariationId;

        public Builder(String name, List<SubscriptionPhase> phases) {
            this.name = name;
            this.phases = phases;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder phases(List<SubscriptionPhase> phases) {
            this.phases = phases;
            return this;
        }

        public Builder subscriptionPlanId(String subscriptionPlanId) {
            this.subscriptionPlanId = OptionalNullable.of((Object)subscriptionPlanId);
            return this;
        }

        public Builder unsetSubscriptionPlanId() {
            this.subscriptionPlanId = null;
            return this;
        }

        public Builder monthlyBillingAnchorDate(Long monthlyBillingAnchorDate) {
            this.monthlyBillingAnchorDate = OptionalNullable.of((Object)monthlyBillingAnchorDate);
            return this;
        }

        public Builder unsetMonthlyBillingAnchorDate() {
            this.monthlyBillingAnchorDate = null;
            return this;
        }

        public Builder canProrate(Boolean canProrate) {
            this.canProrate = OptionalNullable.of((Object)canProrate);
            return this;
        }

        public Builder unsetCanProrate() {
            this.canProrate = null;
            return this;
        }

        public Builder successorPlanVariationId(String successorPlanVariationId) {
            this.successorPlanVariationId = OptionalNullable.of((Object)successorPlanVariationId);
            return this;
        }

        public Builder unsetSuccessorPlanVariationId() {
            this.successorPlanVariationId = null;
            return this;
        }

        public CatalogSubscriptionPlanVariation build() {
            return new CatalogSubscriptionPlanVariation(this.name, this.phases, this.subscriptionPlanId, this.monthlyBillingAnchorDate, this.canProrate, this.successorPlanVariationId);
        }
    }
}

