/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class CategoryPathToRootNode {
    private final OptionalNullable<String> categoryId;
    private final OptionalNullable<String> categoryName;

    @JsonCreator
    public CategoryPathToRootNode(@JsonProperty(value="category_id") String categoryId, @JsonProperty(value="category_name") String categoryName) {
        this.categoryId = OptionalNullable.of((Object)categoryId);
        this.categoryName = OptionalNullable.of((Object)categoryName);
    }

    protected CategoryPathToRootNode(OptionalNullable<String> categoryId, OptionalNullable<String> categoryName) {
        this.categoryId = categoryId;
        this.categoryName = categoryName;
    }

    @JsonGetter(value="category_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCategoryId() {
        return this.categoryId;
    }

    @JsonIgnore
    public String getCategoryId() {
        return (String)OptionalNullable.getFrom(this.categoryId);
    }

    @JsonGetter(value="category_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCategoryName() {
        return this.categoryName;
    }

    @JsonIgnore
    public String getCategoryName() {
        return (String)OptionalNullable.getFrom(this.categoryName);
    }

    public int hashCode() {
        return Objects.hash(this.categoryId, this.categoryName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CategoryPathToRootNode)) {
            return false;
        }
        CategoryPathToRootNode other = (CategoryPathToRootNode)obj;
        return Objects.equals(this.categoryId, other.categoryId) && Objects.equals(this.categoryName, other.categoryName);
    }

    public String toString() {
        return "CategoryPathToRootNode [categoryId=" + this.categoryId + ", categoryName=" + this.categoryName + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.categoryId = this.internalGetCategoryId();
        builder.categoryName = this.internalGetCategoryName();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> categoryId;
        private OptionalNullable<String> categoryName;

        public Builder categoryId(String categoryId) {
            this.categoryId = OptionalNullable.of((Object)categoryId);
            return this;
        }

        public Builder unsetCategoryId() {
            this.categoryId = null;
            return this;
        }

        public Builder categoryName(String categoryName) {
            this.categoryName = OptionalNullable.of((Object)categoryName);
            return this;
        }

        public Builder unsetCategoryName() {
            this.categoryName = null;
            return this;
        }

        public CategoryPathToRootNode build() {
            return new CategoryPathToRootNode(this.categoryId, this.categoryName);
        }
    }
}

