/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class ChangeBillingAnchorDateRequest {
    private final OptionalNullable<Integer> monthlyBillingAnchorDate;
    private final OptionalNullable<String> effectiveDate;

    @JsonCreator
    public ChangeBillingAnchorDateRequest(@JsonProperty(value="monthly_billing_anchor_date") Integer monthlyBillingAnchorDate, @JsonProperty(value="effective_date") String effectiveDate) {
        this.monthlyBillingAnchorDate = OptionalNullable.of((Object)monthlyBillingAnchorDate);
        this.effectiveDate = OptionalNullable.of((Object)effectiveDate);
    }

    protected ChangeBillingAnchorDateRequest(OptionalNullable<Integer> monthlyBillingAnchorDate, OptionalNullable<String> effectiveDate) {
        this.monthlyBillingAnchorDate = monthlyBillingAnchorDate;
        this.effectiveDate = effectiveDate;
    }

    @JsonGetter(value="monthly_billing_anchor_date")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Integer> internalGetMonthlyBillingAnchorDate() {
        return this.monthlyBillingAnchorDate;
    }

    @JsonIgnore
    public Integer getMonthlyBillingAnchorDate() {
        return (Integer)OptionalNullable.getFrom(this.monthlyBillingAnchorDate);
    }

    @JsonGetter(value="effective_date")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetEffectiveDate() {
        return this.effectiveDate;
    }

    @JsonIgnore
    public String getEffectiveDate() {
        return (String)OptionalNullable.getFrom(this.effectiveDate);
    }

    public int hashCode() {
        return Objects.hash(this.monthlyBillingAnchorDate, this.effectiveDate);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ChangeBillingAnchorDateRequest)) {
            return false;
        }
        ChangeBillingAnchorDateRequest other = (ChangeBillingAnchorDateRequest)obj;
        return Objects.equals(this.monthlyBillingAnchorDate, other.monthlyBillingAnchorDate) && Objects.equals(this.effectiveDate, other.effectiveDate);
    }

    public String toString() {
        return "ChangeBillingAnchorDateRequest [monthlyBillingAnchorDate=" + this.monthlyBillingAnchorDate + ", effectiveDate=" + this.effectiveDate + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.monthlyBillingAnchorDate = this.internalGetMonthlyBillingAnchorDate();
        builder.effectiveDate = this.internalGetEffectiveDate();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<Integer> monthlyBillingAnchorDate;
        private OptionalNullable<String> effectiveDate;

        public Builder monthlyBillingAnchorDate(Integer monthlyBillingAnchorDate) {
            this.monthlyBillingAnchorDate = OptionalNullable.of((Object)monthlyBillingAnchorDate);
            return this;
        }

        public Builder unsetMonthlyBillingAnchorDate() {
            this.monthlyBillingAnchorDate = null;
            return this;
        }

        public Builder effectiveDate(String effectiveDate) {
            this.effectiveDate = OptionalNullable.of((Object)effectiveDate);
            return this;
        }

        public Builder unsetEffectiveDate() {
            this.effectiveDate = null;
            return this;
        }

        public ChangeBillingAnchorDateRequest build() {
            return new ChangeBillingAnchorDateRequest(this.monthlyBillingAnchorDate, this.effectiveDate);
        }
    }
}

