/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.CheckoutLocationSettingsBranding;
import com.squareup.square.models.CheckoutLocationSettingsCoupons;
import com.squareup.square.models.CheckoutLocationSettingsPolicy;
import com.squareup.square.models.CheckoutLocationSettingsTipping;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class CheckoutLocationSettings {
    private final OptionalNullable<String> locationId;
    private final OptionalNullable<Boolean> customerNotesEnabled;
    private final OptionalNullable<List<CheckoutLocationSettingsPolicy>> policies;
    private final CheckoutLocationSettingsBranding branding;
    private final CheckoutLocationSettingsTipping tipping;
    private final CheckoutLocationSettingsCoupons coupons;
    private final String updatedAt;

    @JsonCreator
    public CheckoutLocationSettings(@JsonProperty(value="location_id") String locationId, @JsonProperty(value="customer_notes_enabled") Boolean customerNotesEnabled, @JsonProperty(value="policies") List<CheckoutLocationSettingsPolicy> policies, @JsonProperty(value="branding") CheckoutLocationSettingsBranding branding, @JsonProperty(value="tipping") CheckoutLocationSettingsTipping tipping, @JsonProperty(value="coupons") CheckoutLocationSettingsCoupons coupons, @JsonProperty(value="updated_at") String updatedAt) {
        this.locationId = OptionalNullable.of((Object)locationId);
        this.customerNotesEnabled = OptionalNullable.of((Object)customerNotesEnabled);
        this.policies = OptionalNullable.of(policies);
        this.branding = branding;
        this.tipping = tipping;
        this.coupons = coupons;
        this.updatedAt = updatedAt;
    }

    protected CheckoutLocationSettings(OptionalNullable<String> locationId, OptionalNullable<Boolean> customerNotesEnabled, OptionalNullable<List<CheckoutLocationSettingsPolicy>> policies, CheckoutLocationSettingsBranding branding, CheckoutLocationSettingsTipping tipping, CheckoutLocationSettingsCoupons coupons, String updatedAt) {
        this.locationId = locationId;
        this.customerNotesEnabled = customerNotesEnabled;
        this.policies = policies;
        this.branding = branding;
        this.tipping = tipping;
        this.coupons = coupons;
        this.updatedAt = updatedAt;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetLocationId() {
        return this.locationId;
    }

    @JsonIgnore
    public String getLocationId() {
        return (String)OptionalNullable.getFrom(this.locationId);
    }

    @JsonGetter(value="customer_notes_enabled")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetCustomerNotesEnabled() {
        return this.customerNotesEnabled;
    }

    @JsonIgnore
    public Boolean getCustomerNotesEnabled() {
        return (Boolean)OptionalNullable.getFrom(this.customerNotesEnabled);
    }

    @JsonGetter(value="policies")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<CheckoutLocationSettingsPolicy>> internalGetPolicies() {
        return this.policies;
    }

    @JsonIgnore
    public List<CheckoutLocationSettingsPolicy> getPolicies() {
        return (List)OptionalNullable.getFrom(this.policies);
    }

    @JsonGetter(value="branding")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CheckoutLocationSettingsBranding getBranding() {
        return this.branding;
    }

    @JsonGetter(value="tipping")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CheckoutLocationSettingsTipping getTipping() {
        return this.tipping;
    }

    @JsonGetter(value="coupons")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CheckoutLocationSettingsCoupons getCoupons() {
        return this.coupons;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.customerNotesEnabled, this.policies, this.branding, this.tipping, this.coupons, this.updatedAt);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CheckoutLocationSettings)) {
            return false;
        }
        CheckoutLocationSettings other = (CheckoutLocationSettings)obj;
        return Objects.equals(this.locationId, other.locationId) && Objects.equals(this.customerNotesEnabled, other.customerNotesEnabled) && Objects.equals(this.policies, other.policies) && Objects.equals(this.branding, other.branding) && Objects.equals(this.tipping, other.tipping) && Objects.equals(this.coupons, other.coupons) && Objects.equals(this.updatedAt, other.updatedAt);
    }

    public String toString() {
        return "CheckoutLocationSettings [locationId=" + this.locationId + ", customerNotesEnabled=" + this.customerNotesEnabled + ", policies=" + this.policies + ", branding=" + this.branding + ", tipping=" + this.tipping + ", coupons=" + this.coupons + ", updatedAt=" + this.updatedAt + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().branding(this.getBranding()).tipping(this.getTipping()).coupons(this.getCoupons()).updatedAt(this.getUpdatedAt());
        builder.locationId = this.internalGetLocationId();
        builder.customerNotesEnabled = this.internalGetCustomerNotesEnabled();
        builder.policies = this.internalGetPolicies();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> locationId;
        private OptionalNullable<Boolean> customerNotesEnabled;
        private OptionalNullable<List<CheckoutLocationSettingsPolicy>> policies;
        private CheckoutLocationSettingsBranding branding;
        private CheckoutLocationSettingsTipping tipping;
        private CheckoutLocationSettingsCoupons coupons;
        private String updatedAt;

        public Builder locationId(String locationId) {
            this.locationId = OptionalNullable.of((Object)locationId);
            return this;
        }

        public Builder unsetLocationId() {
            this.locationId = null;
            return this;
        }

        public Builder customerNotesEnabled(Boolean customerNotesEnabled) {
            this.customerNotesEnabled = OptionalNullable.of((Object)customerNotesEnabled);
            return this;
        }

        public Builder unsetCustomerNotesEnabled() {
            this.customerNotesEnabled = null;
            return this;
        }

        public Builder policies(List<CheckoutLocationSettingsPolicy> policies) {
            this.policies = OptionalNullable.of(policies);
            return this;
        }

        public Builder unsetPolicies() {
            this.policies = null;
            return this;
        }

        public Builder branding(CheckoutLocationSettingsBranding branding) {
            this.branding = branding;
            return this;
        }

        public Builder tipping(CheckoutLocationSettingsTipping tipping) {
            this.tipping = tipping;
            return this;
        }

        public Builder coupons(CheckoutLocationSettingsCoupons coupons) {
            this.coupons = coupons;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public CheckoutLocationSettings build() {
            return new CheckoutLocationSettings(this.locationId, this.customerNotesEnabled, this.policies, this.branding, this.tipping, this.coupons, this.updatedAt);
        }
    }
}

