/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class CheckoutLocationSettingsBranding {
    private final String headerType;
    private final OptionalNullable<String> buttonColor;
    private final String buttonShape;

    @JsonCreator
    public CheckoutLocationSettingsBranding(@JsonProperty(value="header_type") String headerType, @JsonProperty(value="button_color") String buttonColor, @JsonProperty(value="button_shape") String buttonShape) {
        this.headerType = headerType;
        this.buttonColor = OptionalNullable.of((Object)buttonColor);
        this.buttonShape = buttonShape;
    }

    protected CheckoutLocationSettingsBranding(String headerType, OptionalNullable<String> buttonColor, String buttonShape) {
        this.headerType = headerType;
        this.buttonColor = buttonColor;
        this.buttonShape = buttonShape;
    }

    @JsonGetter(value="header_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getHeaderType() {
        return this.headerType;
    }

    @JsonGetter(value="button_color")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetButtonColor() {
        return this.buttonColor;
    }

    @JsonIgnore
    public String getButtonColor() {
        return (String)OptionalNullable.getFrom(this.buttonColor);
    }

    @JsonGetter(value="button_shape")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getButtonShape() {
        return this.buttonShape;
    }

    public int hashCode() {
        return Objects.hash(this.headerType, this.buttonColor, this.buttonShape);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CheckoutLocationSettingsBranding)) {
            return false;
        }
        CheckoutLocationSettingsBranding other = (CheckoutLocationSettingsBranding)obj;
        return Objects.equals(this.headerType, other.headerType) && Objects.equals(this.buttonColor, other.buttonColor) && Objects.equals(this.buttonShape, other.buttonShape);
    }

    public String toString() {
        return "CheckoutLocationSettingsBranding [headerType=" + this.headerType + ", buttonColor=" + this.buttonColor + ", buttonShape=" + this.buttonShape + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().headerType(this.getHeaderType()).buttonShape(this.getButtonShape());
        builder.buttonColor = this.internalGetButtonColor();
        return builder;
    }

    public static class Builder {
        private String headerType;
        private OptionalNullable<String> buttonColor;
        private String buttonShape;

        public Builder headerType(String headerType) {
            this.headerType = headerType;
            return this;
        }

        public Builder buttonColor(String buttonColor) {
            this.buttonColor = OptionalNullable.of((Object)buttonColor);
            return this;
        }

        public Builder unsetButtonColor() {
            this.buttonColor = null;
            return this;
        }

        public Builder buttonShape(String buttonShape) {
            this.buttonShape = buttonShape;
            return this;
        }

        public CheckoutLocationSettingsBranding build() {
            return new CheckoutLocationSettingsBranding(this.headerType, this.buttonColor, this.buttonShape);
        }
    }
}

