/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class CheckoutLocationSettingsTipping {
    private final OptionalNullable<List<Integer>> percentages;
    private final OptionalNullable<Boolean> smartTippingEnabled;
    private final OptionalNullable<Integer> defaultPercent;
    private final OptionalNullable<List<Money>> smartTips;
    private final Money defaultSmartTip;

    @JsonCreator
    public CheckoutLocationSettingsTipping(@JsonProperty(value="percentages") List<Integer> percentages, @JsonProperty(value="smart_tipping_enabled") Boolean smartTippingEnabled, @JsonProperty(value="default_percent") Integer defaultPercent, @JsonProperty(value="smart_tips") List<Money> smartTips, @JsonProperty(value="default_smart_tip") Money defaultSmartTip) {
        this.percentages = OptionalNullable.of(percentages);
        this.smartTippingEnabled = OptionalNullable.of((Object)smartTippingEnabled);
        this.defaultPercent = OptionalNullable.of((Object)defaultPercent);
        this.smartTips = OptionalNullable.of(smartTips);
        this.defaultSmartTip = defaultSmartTip;
    }

    protected CheckoutLocationSettingsTipping(OptionalNullable<List<Integer>> percentages, OptionalNullable<Boolean> smartTippingEnabled, OptionalNullable<Integer> defaultPercent, OptionalNullable<List<Money>> smartTips, Money defaultSmartTip) {
        this.percentages = percentages;
        this.smartTippingEnabled = smartTippingEnabled;
        this.defaultPercent = defaultPercent;
        this.smartTips = smartTips;
        this.defaultSmartTip = defaultSmartTip;
    }

    @JsonGetter(value="percentages")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<Integer>> internalGetPercentages() {
        return this.percentages;
    }

    @JsonIgnore
    public List<Integer> getPercentages() {
        return (List)OptionalNullable.getFrom(this.percentages);
    }

    @JsonGetter(value="smart_tipping_enabled")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetSmartTippingEnabled() {
        return this.smartTippingEnabled;
    }

    @JsonIgnore
    public Boolean getSmartTippingEnabled() {
        return (Boolean)OptionalNullable.getFrom(this.smartTippingEnabled);
    }

    @JsonGetter(value="default_percent")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Integer> internalGetDefaultPercent() {
        return this.defaultPercent;
    }

    @JsonIgnore
    public Integer getDefaultPercent() {
        return (Integer)OptionalNullable.getFrom(this.defaultPercent);
    }

    @JsonGetter(value="smart_tips")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<Money>> internalGetSmartTips() {
        return this.smartTips;
    }

    @JsonIgnore
    public List<Money> getSmartTips() {
        return (List)OptionalNullable.getFrom(this.smartTips);
    }

    @JsonGetter(value="default_smart_tip")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getDefaultSmartTip() {
        return this.defaultSmartTip;
    }

    public int hashCode() {
        return Objects.hash(this.percentages, this.smartTippingEnabled, this.defaultPercent, this.smartTips, this.defaultSmartTip);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CheckoutLocationSettingsTipping)) {
            return false;
        }
        CheckoutLocationSettingsTipping other = (CheckoutLocationSettingsTipping)obj;
        return Objects.equals(this.percentages, other.percentages) && Objects.equals(this.smartTippingEnabled, other.smartTippingEnabled) && Objects.equals(this.defaultPercent, other.defaultPercent) && Objects.equals(this.smartTips, other.smartTips) && Objects.equals(this.defaultSmartTip, other.defaultSmartTip);
    }

    public String toString() {
        return "CheckoutLocationSettingsTipping [percentages=" + this.percentages + ", smartTippingEnabled=" + this.smartTippingEnabled + ", defaultPercent=" + this.defaultPercent + ", smartTips=" + this.smartTips + ", defaultSmartTip=" + this.defaultSmartTip + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().defaultSmartTip(this.getDefaultSmartTip());
        builder.percentages = this.internalGetPercentages();
        builder.smartTippingEnabled = this.internalGetSmartTippingEnabled();
        builder.defaultPercent = this.internalGetDefaultPercent();
        builder.smartTips = this.internalGetSmartTips();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<List<Integer>> percentages;
        private OptionalNullable<Boolean> smartTippingEnabled;
        private OptionalNullable<Integer> defaultPercent;
        private OptionalNullable<List<Money>> smartTips;
        private Money defaultSmartTip;

        public Builder percentages(List<Integer> percentages) {
            this.percentages = OptionalNullable.of(percentages);
            return this;
        }

        public Builder unsetPercentages() {
            this.percentages = null;
            return this;
        }

        public Builder smartTippingEnabled(Boolean smartTippingEnabled) {
            this.smartTippingEnabled = OptionalNullable.of((Object)smartTippingEnabled);
            return this;
        }

        public Builder unsetSmartTippingEnabled() {
            this.smartTippingEnabled = null;
            return this;
        }

        public Builder defaultPercent(Integer defaultPercent) {
            this.defaultPercent = OptionalNullable.of((Object)defaultPercent);
            return this;
        }

        public Builder unsetDefaultPercent() {
            this.defaultPercent = null;
            return this;
        }

        public Builder smartTips(List<Money> smartTips) {
            this.smartTips = OptionalNullable.of(smartTips);
            return this;
        }

        public Builder unsetSmartTips() {
            this.smartTips = null;
            return this;
        }

        public Builder defaultSmartTip(Money defaultSmartTip) {
            this.defaultSmartTip = defaultSmartTip;
            return this;
        }

        public CheckoutLocationSettingsTipping build() {
            return new CheckoutLocationSettingsTipping(this.percentages, this.smartTippingEnabled, this.defaultPercent, this.smartTips, this.defaultSmartTip);
        }
    }
}

