/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.AcceptedPaymentMethods;
import com.squareup.square.models.CustomField;
import com.squareup.square.models.Money;
import com.squareup.square.models.ShippingFee;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class CheckoutOptions {
    private final OptionalNullable<Boolean> allowTipping;
    private final OptionalNullable<List<CustomField>> customFields;
    private final OptionalNullable<String> subscriptionPlanId;
    private final OptionalNullable<String> redirectUrl;
    private final OptionalNullable<String> merchantSupportEmail;
    private final OptionalNullable<Boolean> askForShippingAddress;
    private final AcceptedPaymentMethods acceptedPaymentMethods;
    private final Money appFeeMoney;
    private final ShippingFee shippingFee;
    private final OptionalNullable<Boolean> enableCoupon;
    private final OptionalNullable<Boolean> enableLoyalty;

    @JsonCreator
    public CheckoutOptions(@JsonProperty(value="allow_tipping") Boolean allowTipping, @JsonProperty(value="custom_fields") List<CustomField> customFields, @JsonProperty(value="subscription_plan_id") String subscriptionPlanId, @JsonProperty(value="redirect_url") String redirectUrl, @JsonProperty(value="merchant_support_email") String merchantSupportEmail, @JsonProperty(value="ask_for_shipping_address") Boolean askForShippingAddress, @JsonProperty(value="accepted_payment_methods") AcceptedPaymentMethods acceptedPaymentMethods, @JsonProperty(value="app_fee_money") Money appFeeMoney, @JsonProperty(value="shipping_fee") ShippingFee shippingFee, @JsonProperty(value="enable_coupon") Boolean enableCoupon, @JsonProperty(value="enable_loyalty") Boolean enableLoyalty) {
        this.allowTipping = OptionalNullable.of((Object)allowTipping);
        this.customFields = OptionalNullable.of(customFields);
        this.subscriptionPlanId = OptionalNullable.of((Object)subscriptionPlanId);
        this.redirectUrl = OptionalNullable.of((Object)redirectUrl);
        this.merchantSupportEmail = OptionalNullable.of((Object)merchantSupportEmail);
        this.askForShippingAddress = OptionalNullable.of((Object)askForShippingAddress);
        this.acceptedPaymentMethods = acceptedPaymentMethods;
        this.appFeeMoney = appFeeMoney;
        this.shippingFee = shippingFee;
        this.enableCoupon = OptionalNullable.of((Object)enableCoupon);
        this.enableLoyalty = OptionalNullable.of((Object)enableLoyalty);
    }

    protected CheckoutOptions(OptionalNullable<Boolean> allowTipping, OptionalNullable<List<CustomField>> customFields, OptionalNullable<String> subscriptionPlanId, OptionalNullable<String> redirectUrl, OptionalNullable<String> merchantSupportEmail, OptionalNullable<Boolean> askForShippingAddress, AcceptedPaymentMethods acceptedPaymentMethods, Money appFeeMoney, ShippingFee shippingFee, OptionalNullable<Boolean> enableCoupon, OptionalNullable<Boolean> enableLoyalty) {
        this.allowTipping = allowTipping;
        this.customFields = customFields;
        this.subscriptionPlanId = subscriptionPlanId;
        this.redirectUrl = redirectUrl;
        this.merchantSupportEmail = merchantSupportEmail;
        this.askForShippingAddress = askForShippingAddress;
        this.acceptedPaymentMethods = acceptedPaymentMethods;
        this.appFeeMoney = appFeeMoney;
        this.shippingFee = shippingFee;
        this.enableCoupon = enableCoupon;
        this.enableLoyalty = enableLoyalty;
    }

    @JsonGetter(value="allow_tipping")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetAllowTipping() {
        return this.allowTipping;
    }

    @JsonIgnore
    public Boolean getAllowTipping() {
        return (Boolean)OptionalNullable.getFrom(this.allowTipping);
    }

    @JsonGetter(value="custom_fields")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<CustomField>> internalGetCustomFields() {
        return this.customFields;
    }

    @JsonIgnore
    public List<CustomField> getCustomFields() {
        return (List)OptionalNullable.getFrom(this.customFields);
    }

    @JsonGetter(value="subscription_plan_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetSubscriptionPlanId() {
        return this.subscriptionPlanId;
    }

    @JsonIgnore
    public String getSubscriptionPlanId() {
        return (String)OptionalNullable.getFrom(this.subscriptionPlanId);
    }

    @JsonGetter(value="redirect_url")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetRedirectUrl() {
        return this.redirectUrl;
    }

    @JsonIgnore
    public String getRedirectUrl() {
        return (String)OptionalNullable.getFrom(this.redirectUrl);
    }

    @JsonGetter(value="merchant_support_email")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetMerchantSupportEmail() {
        return this.merchantSupportEmail;
    }

    @JsonIgnore
    public String getMerchantSupportEmail() {
        return (String)OptionalNullable.getFrom(this.merchantSupportEmail);
    }

    @JsonGetter(value="ask_for_shipping_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetAskForShippingAddress() {
        return this.askForShippingAddress;
    }

    @JsonIgnore
    public Boolean getAskForShippingAddress() {
        return (Boolean)OptionalNullable.getFrom(this.askForShippingAddress);
    }

    @JsonGetter(value="accepted_payment_methods")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public AcceptedPaymentMethods getAcceptedPaymentMethods() {
        return this.acceptedPaymentMethods;
    }

    @JsonGetter(value="app_fee_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAppFeeMoney() {
        return this.appFeeMoney;
    }

    @JsonGetter(value="shipping_fee")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ShippingFee getShippingFee() {
        return this.shippingFee;
    }

    @JsonGetter(value="enable_coupon")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetEnableCoupon() {
        return this.enableCoupon;
    }

    @JsonIgnore
    public Boolean getEnableCoupon() {
        return (Boolean)OptionalNullable.getFrom(this.enableCoupon);
    }

    @JsonGetter(value="enable_loyalty")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetEnableLoyalty() {
        return this.enableLoyalty;
    }

    @JsonIgnore
    public Boolean getEnableLoyalty() {
        return (Boolean)OptionalNullable.getFrom(this.enableLoyalty);
    }

    public int hashCode() {
        return Objects.hash(this.allowTipping, this.customFields, this.subscriptionPlanId, this.redirectUrl, this.merchantSupportEmail, this.askForShippingAddress, this.acceptedPaymentMethods, this.appFeeMoney, this.shippingFee, this.enableCoupon, this.enableLoyalty);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CheckoutOptions)) {
            return false;
        }
        CheckoutOptions other = (CheckoutOptions)obj;
        return Objects.equals(this.allowTipping, other.allowTipping) && Objects.equals(this.customFields, other.customFields) && Objects.equals(this.subscriptionPlanId, other.subscriptionPlanId) && Objects.equals(this.redirectUrl, other.redirectUrl) && Objects.equals(this.merchantSupportEmail, other.merchantSupportEmail) && Objects.equals(this.askForShippingAddress, other.askForShippingAddress) && Objects.equals(this.acceptedPaymentMethods, other.acceptedPaymentMethods) && Objects.equals(this.appFeeMoney, other.appFeeMoney) && Objects.equals(this.shippingFee, other.shippingFee) && Objects.equals(this.enableCoupon, other.enableCoupon) && Objects.equals(this.enableLoyalty, other.enableLoyalty);
    }

    public String toString() {
        return "CheckoutOptions [allowTipping=" + this.allowTipping + ", customFields=" + this.customFields + ", subscriptionPlanId=" + this.subscriptionPlanId + ", redirectUrl=" + this.redirectUrl + ", merchantSupportEmail=" + this.merchantSupportEmail + ", askForShippingAddress=" + this.askForShippingAddress + ", acceptedPaymentMethods=" + this.acceptedPaymentMethods + ", appFeeMoney=" + this.appFeeMoney + ", shippingFee=" + this.shippingFee + ", enableCoupon=" + this.enableCoupon + ", enableLoyalty=" + this.enableLoyalty + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().acceptedPaymentMethods(this.getAcceptedPaymentMethods()).appFeeMoney(this.getAppFeeMoney()).shippingFee(this.getShippingFee());
        builder.allowTipping = this.internalGetAllowTipping();
        builder.customFields = this.internalGetCustomFields();
        builder.subscriptionPlanId = this.internalGetSubscriptionPlanId();
        builder.redirectUrl = this.internalGetRedirectUrl();
        builder.merchantSupportEmail = this.internalGetMerchantSupportEmail();
        builder.askForShippingAddress = this.internalGetAskForShippingAddress();
        builder.enableCoupon = this.internalGetEnableCoupon();
        builder.enableLoyalty = this.internalGetEnableLoyalty();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<Boolean> allowTipping;
        private OptionalNullable<List<CustomField>> customFields;
        private OptionalNullable<String> subscriptionPlanId;
        private OptionalNullable<String> redirectUrl;
        private OptionalNullable<String> merchantSupportEmail;
        private OptionalNullable<Boolean> askForShippingAddress;
        private AcceptedPaymentMethods acceptedPaymentMethods;
        private Money appFeeMoney;
        private ShippingFee shippingFee;
        private OptionalNullable<Boolean> enableCoupon;
        private OptionalNullable<Boolean> enableLoyalty;

        public Builder allowTipping(Boolean allowTipping) {
            this.allowTipping = OptionalNullable.of((Object)allowTipping);
            return this;
        }

        public Builder unsetAllowTipping() {
            this.allowTipping = null;
            return this;
        }

        public Builder customFields(List<CustomField> customFields) {
            this.customFields = OptionalNullable.of(customFields);
            return this;
        }

        public Builder unsetCustomFields() {
            this.customFields = null;
            return this;
        }

        public Builder subscriptionPlanId(String subscriptionPlanId) {
            this.subscriptionPlanId = OptionalNullable.of((Object)subscriptionPlanId);
            return this;
        }

        public Builder unsetSubscriptionPlanId() {
            this.subscriptionPlanId = null;
            return this;
        }

        public Builder redirectUrl(String redirectUrl) {
            this.redirectUrl = OptionalNullable.of((Object)redirectUrl);
            return this;
        }

        public Builder unsetRedirectUrl() {
            this.redirectUrl = null;
            return this;
        }

        public Builder merchantSupportEmail(String merchantSupportEmail) {
            this.merchantSupportEmail = OptionalNullable.of((Object)merchantSupportEmail);
            return this;
        }

        public Builder unsetMerchantSupportEmail() {
            this.merchantSupportEmail = null;
            return this;
        }

        public Builder askForShippingAddress(Boolean askForShippingAddress) {
            this.askForShippingAddress = OptionalNullable.of((Object)askForShippingAddress);
            return this;
        }

        public Builder unsetAskForShippingAddress() {
            this.askForShippingAddress = null;
            return this;
        }

        public Builder acceptedPaymentMethods(AcceptedPaymentMethods acceptedPaymentMethods) {
            this.acceptedPaymentMethods = acceptedPaymentMethods;
            return this;
        }

        public Builder appFeeMoney(Money appFeeMoney) {
            this.appFeeMoney = appFeeMoney;
            return this;
        }

        public Builder shippingFee(ShippingFee shippingFee) {
            this.shippingFee = shippingFee;
            return this;
        }

        public Builder enableCoupon(Boolean enableCoupon) {
            this.enableCoupon = OptionalNullable.of((Object)enableCoupon);
            return this;
        }

        public Builder unsetEnableCoupon() {
            this.enableCoupon = null;
            return this;
        }

        public Builder enableLoyalty(Boolean enableLoyalty) {
            this.enableLoyalty = OptionalNullable.of((Object)enableLoyalty);
            return this;
        }

        public Builder unsetEnableLoyalty() {
            this.enableLoyalty = null;
            return this;
        }

        public CheckoutOptions build() {
            return new CheckoutOptions(this.allowTipping, this.customFields, this.subscriptionPlanId, this.redirectUrl, this.merchantSupportEmail, this.askForShippingAddress, this.acceptedPaymentMethods, this.appFeeMoney, this.shippingFee, this.enableCoupon, this.enableLoyalty);
        }
    }
}

