/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.DeviceComponentDetailsApplicationDetails;
import com.squareup.square.models.DeviceComponentDetailsBatteryDetails;
import com.squareup.square.models.DeviceComponentDetailsCardReaderDetails;
import com.squareup.square.models.DeviceComponentDetailsEthernetDetails;
import com.squareup.square.models.DeviceComponentDetailsWiFiDetails;
import java.util.Objects;

public class Component {
    private final String type;
    private final DeviceComponentDetailsApplicationDetails applicationDetails;
    private final DeviceComponentDetailsCardReaderDetails cardReaderDetails;
    private final DeviceComponentDetailsBatteryDetails batteryDetails;
    private final DeviceComponentDetailsWiFiDetails wifiDetails;
    private final DeviceComponentDetailsEthernetDetails ethernetDetails;

    @JsonCreator
    public Component(@JsonProperty(value="type") String type, @JsonProperty(value="application_details") DeviceComponentDetailsApplicationDetails applicationDetails, @JsonProperty(value="card_reader_details") DeviceComponentDetailsCardReaderDetails cardReaderDetails, @JsonProperty(value="battery_details") DeviceComponentDetailsBatteryDetails batteryDetails, @JsonProperty(value="wifi_details") DeviceComponentDetailsWiFiDetails wifiDetails, @JsonProperty(value="ethernet_details") DeviceComponentDetailsEthernetDetails ethernetDetails) {
        this.type = type;
        this.applicationDetails = applicationDetails;
        this.cardReaderDetails = cardReaderDetails;
        this.batteryDetails = batteryDetails;
        this.wifiDetails = wifiDetails;
        this.ethernetDetails = ethernetDetails;
    }

    @JsonGetter(value="type")
    public String getType() {
        return this.type;
    }

    @JsonGetter(value="application_details")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public DeviceComponentDetailsApplicationDetails getApplicationDetails() {
        return this.applicationDetails;
    }

    @JsonGetter(value="card_reader_details")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public DeviceComponentDetailsCardReaderDetails getCardReaderDetails() {
        return this.cardReaderDetails;
    }

    @JsonGetter(value="battery_details")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public DeviceComponentDetailsBatteryDetails getBatteryDetails() {
        return this.batteryDetails;
    }

    @JsonGetter(value="wifi_details")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public DeviceComponentDetailsWiFiDetails getWifiDetails() {
        return this.wifiDetails;
    }

    @JsonGetter(value="ethernet_details")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public DeviceComponentDetailsEthernetDetails getEthernetDetails() {
        return this.ethernetDetails;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.applicationDetails, this.cardReaderDetails, this.batteryDetails, this.wifiDetails, this.ethernetDetails);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Component)) {
            return false;
        }
        Component other = (Component)obj;
        return Objects.equals(this.type, other.type) && Objects.equals(this.applicationDetails, other.applicationDetails) && Objects.equals(this.cardReaderDetails, other.cardReaderDetails) && Objects.equals(this.batteryDetails, other.batteryDetails) && Objects.equals(this.wifiDetails, other.wifiDetails) && Objects.equals(this.ethernetDetails, other.ethernetDetails);
    }

    public String toString() {
        return "Component [type=" + this.type + ", applicationDetails=" + this.applicationDetails + ", cardReaderDetails=" + this.cardReaderDetails + ", batteryDetails=" + this.batteryDetails + ", wifiDetails=" + this.wifiDetails + ", ethernetDetails=" + this.ethernetDetails + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.type).applicationDetails(this.getApplicationDetails()).cardReaderDetails(this.getCardReaderDetails()).batteryDetails(this.getBatteryDetails()).wifiDetails(this.getWifiDetails()).ethernetDetails(this.getEthernetDetails());
        return builder;
    }

    public static class Builder {
        private String type;
        private DeviceComponentDetailsApplicationDetails applicationDetails;
        private DeviceComponentDetailsCardReaderDetails cardReaderDetails;
        private DeviceComponentDetailsBatteryDetails batteryDetails;
        private DeviceComponentDetailsWiFiDetails wifiDetails;
        private DeviceComponentDetailsEthernetDetails ethernetDetails;

        public Builder(String type) {
            this.type = type;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder applicationDetails(DeviceComponentDetailsApplicationDetails applicationDetails) {
            this.applicationDetails = applicationDetails;
            return this;
        }

        public Builder cardReaderDetails(DeviceComponentDetailsCardReaderDetails cardReaderDetails) {
            this.cardReaderDetails = cardReaderDetails;
            return this;
        }

        public Builder batteryDetails(DeviceComponentDetailsBatteryDetails batteryDetails) {
            this.batteryDetails = batteryDetails;
            return this;
        }

        public Builder wifiDetails(DeviceComponentDetailsWiFiDetails wifiDetails) {
            this.wifiDetails = wifiDetails;
            return this;
        }

        public Builder ethernetDetails(DeviceComponentDetailsEthernetDetails ethernetDetails) {
            this.ethernetDetails = ethernetDetails;
            return this;
        }

        public Component build() {
            return new Component(this.type, this.applicationDetails, this.cardReaderDetails, this.batteryDetails, this.wifiDetails, this.ethernetDetails);
        }
    }
}

