/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class Coordinates {
    private final OptionalNullable<Double> latitude;
    private final OptionalNullable<Double> longitude;

    @JsonCreator
    public Coordinates(@JsonProperty(value="latitude") Double latitude, @JsonProperty(value="longitude") Double longitude) {
        this.latitude = OptionalNullable.of((Object)latitude);
        this.longitude = OptionalNullable.of((Object)longitude);
    }

    protected Coordinates(OptionalNullable<Double> latitude, OptionalNullable<Double> longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    @JsonGetter(value="latitude")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Double> internalGetLatitude() {
        return this.latitude;
    }

    @JsonIgnore
    public Double getLatitude() {
        return (Double)OptionalNullable.getFrom(this.latitude);
    }

    @JsonGetter(value="longitude")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Double> internalGetLongitude() {
        return this.longitude;
    }

    @JsonIgnore
    public Double getLongitude() {
        return (Double)OptionalNullable.getFrom(this.longitude);
    }

    public int hashCode() {
        return Objects.hash(this.latitude, this.longitude);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Coordinates)) {
            return false;
        }
        Coordinates other = (Coordinates)obj;
        return Objects.equals(this.latitude, other.latitude) && Objects.equals(this.longitude, other.longitude);
    }

    public String toString() {
        return "Coordinates [latitude=" + this.latitude + ", longitude=" + this.longitude + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.latitude = this.internalGetLatitude();
        builder.longitude = this.internalGetLongitude();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<Double> latitude;
        private OptionalNullable<Double> longitude;

        public Builder latitude(Double latitude) {
            this.latitude = OptionalNullable.of((Object)latitude);
            return this;
        }

        public Builder unsetLatitude() {
            this.latitude = null;
            return this;
        }

        public Builder longitude(Double longitude) {
            this.longitude = OptionalNullable.of((Object)longitude);
            return this;
        }

        public Builder unsetLongitude() {
            this.longitude = null;
            return this;
        }

        public Coordinates build() {
            return new Coordinates(this.latitude, this.longitude);
        }
    }
}

