/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.BreakType;
import java.util.Objects;

public class CreateBreakTypeRequest {
    private final String idempotencyKey;
    private final BreakType breakType;

    @JsonCreator
    public CreateBreakTypeRequest(@JsonProperty(value="break_type") BreakType breakType, @JsonProperty(value="idempotency_key") String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
        this.breakType = breakType;
    }

    @JsonGetter(value="idempotency_key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonGetter(value="break_type")
    public BreakType getBreakType() {
        return this.breakType;
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.breakType);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateBreakTypeRequest)) {
            return false;
        }
        CreateBreakTypeRequest other = (CreateBreakTypeRequest)obj;
        return Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.breakType, other.breakType);
    }

    public String toString() {
        return "CreateBreakTypeRequest [breakType=" + this.breakType + ", idempotencyKey=" + this.idempotencyKey + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.breakType).idempotencyKey(this.getIdempotencyKey());
        return builder;
    }

    public static class Builder {
        private BreakType breakType;
        private String idempotencyKey;

        public Builder(BreakType breakType) {
            this.breakType = breakType;
        }

        public Builder breakType(BreakType breakType) {
            this.breakType = breakType;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreateBreakTypeRequest build() {
            return new CreateBreakTypeRequest(this.breakType, this.idempotencyKey);
        }
    }
}

