/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Checkout;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class CreateCheckoutResponse {
    private HttpContext httpContext;
    private final Checkout checkout;
    private final List<Error> errors;

    @JsonCreator
    public CreateCheckoutResponse(@JsonProperty(value="checkout") Checkout checkout, @JsonProperty(value="errors") List<Error> errors) {
        this.checkout = checkout;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="checkout")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Checkout getCheckout() {
        return this.checkout;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.checkout, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateCheckoutResponse)) {
            return false;
        }
        CreateCheckoutResponse other = (CreateCheckoutResponse)obj;
        return Objects.equals(this.checkout, other.checkout) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "CreateCheckoutResponse [checkout=" + this.checkout + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().checkout(this.getCheckout()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private Checkout checkout;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder checkout(Checkout checkout) {
            this.checkout = checkout;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public CreateCheckoutResponse build() {
            CreateCheckoutResponse model = new CreateCheckoutResponse(this.checkout, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

