/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.GiftCardActivity;
import java.util.Objects;

public class CreateGiftCardActivityRequest {
    private final String idempotencyKey;
    private final GiftCardActivity giftCardActivity;

    @JsonCreator
    public CreateGiftCardActivityRequest(@JsonProperty(value="idempotency_key") String idempotencyKey, @JsonProperty(value="gift_card_activity") GiftCardActivity giftCardActivity) {
        this.idempotencyKey = idempotencyKey;
        this.giftCardActivity = giftCardActivity;
    }

    @JsonGetter(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonGetter(value="gift_card_activity")
    public GiftCardActivity getGiftCardActivity() {
        return this.giftCardActivity;
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.giftCardActivity);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateGiftCardActivityRequest)) {
            return false;
        }
        CreateGiftCardActivityRequest other = (CreateGiftCardActivityRequest)obj;
        return Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.giftCardActivity, other.giftCardActivity);
    }

    public String toString() {
        return "CreateGiftCardActivityRequest [idempotencyKey=" + this.idempotencyKey + ", giftCardActivity=" + this.giftCardActivity + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.idempotencyKey, this.giftCardActivity);
        return builder;
    }

    public static class Builder {
        private String idempotencyKey;
        private GiftCardActivity giftCardActivity;

        public Builder(String idempotencyKey, GiftCardActivity giftCardActivity) {
            this.idempotencyKey = idempotencyKey;
            this.giftCardActivity = giftCardActivity;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder giftCardActivity(GiftCardActivity giftCardActivity) {
            this.giftCardActivity = giftCardActivity;
            return this;
        }

        public CreateGiftCardActivityRequest build() {
            return new CreateGiftCardActivityRequest(this.idempotencyKey, this.giftCardActivity);
        }
    }
}

