/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.GiftCard;
import java.util.Objects;

public class CreateGiftCardRequest {
    private final String idempotencyKey;
    private final String locationId;
    private final GiftCard giftCard;

    @JsonCreator
    public CreateGiftCardRequest(@JsonProperty(value="idempotency_key") String idempotencyKey, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="gift_card") GiftCard giftCard) {
        this.idempotencyKey = idempotencyKey;
        this.locationId = locationId;
        this.giftCard = giftCard;
    }

    @JsonGetter(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonGetter(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="gift_card")
    public GiftCard getGiftCard() {
        return this.giftCard;
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.locationId, this.giftCard);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateGiftCardRequest)) {
            return false;
        }
        CreateGiftCardRequest other = (CreateGiftCardRequest)obj;
        return Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.giftCard, other.giftCard);
    }

    public String toString() {
        return "CreateGiftCardRequest [idempotencyKey=" + this.idempotencyKey + ", locationId=" + this.locationId + ", giftCard=" + this.giftCard + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.idempotencyKey, this.locationId, this.giftCard);
        return builder;
    }

    public static class Builder {
        private String idempotencyKey;
        private String locationId;
        private GiftCard giftCard;

        public Builder(String idempotencyKey, String locationId, GiftCard giftCard) {
            this.idempotencyKey = idempotencyKey;
            this.locationId = locationId;
            this.giftCard = giftCard;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder giftCard(GiftCard giftCard) {
            this.giftCard = giftCard;
            return this;
        }

        public CreateGiftCardRequest build() {
            return new CreateGiftCardRequest(this.idempotencyKey, this.locationId, this.giftCard);
        }
    }
}

