/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Invoice;
import java.util.Objects;

public class CreateInvoiceRequest {
    private final Invoice invoice;
    private final String idempotencyKey;

    @JsonCreator
    public CreateInvoiceRequest(@JsonProperty(value="invoice") Invoice invoice, @JsonProperty(value="idempotency_key") String idempotencyKey) {
        this.invoice = invoice;
        this.idempotencyKey = idempotencyKey;
    }

    @JsonGetter(value="invoice")
    public Invoice getInvoice() {
        return this.invoice;
    }

    @JsonGetter(value="idempotency_key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public int hashCode() {
        return Objects.hash(this.invoice, this.idempotencyKey);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateInvoiceRequest)) {
            return false;
        }
        CreateInvoiceRequest other = (CreateInvoiceRequest)obj;
        return Objects.equals(this.invoice, other.invoice) && Objects.equals(this.idempotencyKey, other.idempotencyKey);
    }

    public String toString() {
        return "CreateInvoiceRequest [invoice=" + this.invoice + ", idempotencyKey=" + this.idempotencyKey + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.invoice).idempotencyKey(this.getIdempotencyKey());
        return builder;
    }

    public static class Builder {
        private Invoice invoice;
        private String idempotencyKey;

        public Builder(Invoice invoice) {
            this.invoice = invoice;
        }

        public Builder invoice(Invoice invoice) {
            this.invoice = invoice;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreateInvoiceRequest build() {
            return new CreateInvoiceRequest(this.invoice, this.idempotencyKey);
        }
    }
}

