/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.LoyaltyAccount;
import java.util.List;
import java.util.Objects;

public class CreateLoyaltyAccountResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final LoyaltyAccount loyaltyAccount;

    @JsonCreator
    public CreateLoyaltyAccountResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="loyalty_account") LoyaltyAccount loyaltyAccount) {
        this.errors = errors;
        this.loyaltyAccount = loyaltyAccount;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="loyalty_account")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public LoyaltyAccount getLoyaltyAccount() {
        return this.loyaltyAccount;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.loyaltyAccount);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateLoyaltyAccountResponse)) {
            return false;
        }
        CreateLoyaltyAccountResponse other = (CreateLoyaltyAccountResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.loyaltyAccount, other.loyaltyAccount);
    }

    public String toString() {
        return "CreateLoyaltyAccountResponse [errors=" + this.errors + ", loyaltyAccount=" + this.loyaltyAccount + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).loyaltyAccount(this.getLoyaltyAccount());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private LoyaltyAccount loyaltyAccount;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder loyaltyAccount(LoyaltyAccount loyaltyAccount) {
            this.loyaltyAccount = loyaltyAccount;
            return this;
        }

        public CreateLoyaltyAccountResponse build() {
            CreateLoyaltyAccountResponse model = new CreateLoyaltyAccountResponse(this.errors, this.loyaltyAccount);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

