/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.LoyaltyReward;
import java.util.Objects;

public class CreateLoyaltyRewardRequest {
    private final LoyaltyReward reward;
    private final String idempotencyKey;

    @JsonCreator
    public CreateLoyaltyRewardRequest(@JsonProperty(value="reward") LoyaltyReward reward, @JsonProperty(value="idempotency_key") String idempotencyKey) {
        this.reward = reward;
        this.idempotencyKey = idempotencyKey;
    }

    @JsonGetter(value="reward")
    public LoyaltyReward getReward() {
        return this.reward;
    }

    @JsonGetter(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public int hashCode() {
        return Objects.hash(this.reward, this.idempotencyKey);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateLoyaltyRewardRequest)) {
            return false;
        }
        CreateLoyaltyRewardRequest other = (CreateLoyaltyRewardRequest)obj;
        return Objects.equals(this.reward, other.reward) && Objects.equals(this.idempotencyKey, other.idempotencyKey);
    }

    public String toString() {
        return "CreateLoyaltyRewardRequest [reward=" + this.reward + ", idempotencyKey=" + this.idempotencyKey + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.reward, this.idempotencyKey);
        return builder;
    }

    public static class Builder {
        private LoyaltyReward reward;
        private String idempotencyKey;

        public Builder(LoyaltyReward reward, String idempotencyKey) {
            this.reward = reward;
            this.idempotencyKey = idempotencyKey;
        }

        public Builder reward(LoyaltyReward reward) {
            this.reward = reward;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreateLoyaltyRewardRequest build() {
            return new CreateLoyaltyRewardRequest(this.reward, this.idempotencyKey);
        }
    }
}

