/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class CreateMobileAuthorizationCodeResponse {
    private HttpContext httpContext;
    private final String authorizationCode;
    private final String expiresAt;
    private final List<Error> errors;

    @JsonCreator
    public CreateMobileAuthorizationCodeResponse(@JsonProperty(value="authorization_code") String authorizationCode, @JsonProperty(value="expires_at") String expiresAt, @JsonProperty(value="errors") List<Error> errors) {
        this.authorizationCode = authorizationCode;
        this.expiresAt = expiresAt;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="authorization_code")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAuthorizationCode() {
        return this.authorizationCode;
    }

    @JsonGetter(value="expires_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getExpiresAt() {
        return this.expiresAt;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.authorizationCode, this.expiresAt, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateMobileAuthorizationCodeResponse)) {
            return false;
        }
        CreateMobileAuthorizationCodeResponse other = (CreateMobileAuthorizationCodeResponse)obj;
        return Objects.equals(this.authorizationCode, other.authorizationCode) && Objects.equals(this.expiresAt, other.expiresAt) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "CreateMobileAuthorizationCodeResponse [authorizationCode=" + this.authorizationCode + ", expiresAt=" + this.expiresAt + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().authorizationCode(this.getAuthorizationCode()).expiresAt(this.getExpiresAt()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private String authorizationCode;
        private String expiresAt;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder authorizationCode(String authorizationCode) {
            this.authorizationCode = authorizationCode;
            return this;
        }

        public Builder expiresAt(String expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public CreateMobileAuthorizationCodeResponse build() {
            CreateMobileAuthorizationCodeResponse model = new CreateMobileAuthorizationCodeResponse(this.authorizationCode, this.expiresAt, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

