/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.CheckoutOptions;
import com.squareup.square.models.Order;
import com.squareup.square.models.PrePopulatedData;
import com.squareup.square.models.QuickPay;
import java.util.Objects;

public class CreatePaymentLinkRequest {
    private final String idempotencyKey;
    private final String description;
    private final QuickPay quickPay;
    private final Order order;
    private final CheckoutOptions checkoutOptions;
    private final PrePopulatedData prePopulatedData;
    private final String paymentNote;

    @JsonCreator
    public CreatePaymentLinkRequest(@JsonProperty(value="idempotency_key") String idempotencyKey, @JsonProperty(value="description") String description, @JsonProperty(value="quick_pay") QuickPay quickPay, @JsonProperty(value="order") Order order, @JsonProperty(value="checkout_options") CheckoutOptions checkoutOptions, @JsonProperty(value="pre_populated_data") PrePopulatedData prePopulatedData, @JsonProperty(value="payment_note") String paymentNote) {
        this.idempotencyKey = idempotencyKey;
        this.description = description;
        this.quickPay = quickPay;
        this.order = order;
        this.checkoutOptions = checkoutOptions;
        this.prePopulatedData = prePopulatedData;
        this.paymentNote = paymentNote;
    }

    @JsonGetter(value="idempotency_key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonGetter(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDescription() {
        return this.description;
    }

    @JsonGetter(value="quick_pay")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public QuickPay getQuickPay() {
        return this.quickPay;
    }

    @JsonGetter(value="order")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Order getOrder() {
        return this.order;
    }

    @JsonGetter(value="checkout_options")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CheckoutOptions getCheckoutOptions() {
        return this.checkoutOptions;
    }

    @JsonGetter(value="pre_populated_data")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PrePopulatedData getPrePopulatedData() {
        return this.prePopulatedData;
    }

    @JsonGetter(value="payment_note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaymentNote() {
        return this.paymentNote;
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.description, this.quickPay, this.order, this.checkoutOptions, this.prePopulatedData, this.paymentNote);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreatePaymentLinkRequest)) {
            return false;
        }
        CreatePaymentLinkRequest other = (CreatePaymentLinkRequest)obj;
        return Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.description, other.description) && Objects.equals(this.quickPay, other.quickPay) && Objects.equals(this.order, other.order) && Objects.equals(this.checkoutOptions, other.checkoutOptions) && Objects.equals(this.prePopulatedData, other.prePopulatedData) && Objects.equals(this.paymentNote, other.paymentNote);
    }

    public String toString() {
        return "CreatePaymentLinkRequest [idempotencyKey=" + this.idempotencyKey + ", description=" + this.description + ", quickPay=" + this.quickPay + ", order=" + this.order + ", checkoutOptions=" + this.checkoutOptions + ", prePopulatedData=" + this.prePopulatedData + ", paymentNote=" + this.paymentNote + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().idempotencyKey(this.getIdempotencyKey()).description(this.getDescription()).quickPay(this.getQuickPay()).order(this.getOrder()).checkoutOptions(this.getCheckoutOptions()).prePopulatedData(this.getPrePopulatedData()).paymentNote(this.getPaymentNote());
        return builder;
    }

    public static class Builder {
        private String idempotencyKey;
        private String description;
        private QuickPay quickPay;
        private Order order;
        private CheckoutOptions checkoutOptions;
        private PrePopulatedData prePopulatedData;
        private String paymentNote;

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder quickPay(QuickPay quickPay) {
            this.quickPay = quickPay;
            return this;
        }

        public Builder order(Order order) {
            this.order = order;
            return this;
        }

        public Builder checkoutOptions(CheckoutOptions checkoutOptions) {
            this.checkoutOptions = checkoutOptions;
            return this;
        }

        public Builder prePopulatedData(PrePopulatedData prePopulatedData) {
            this.prePopulatedData = prePopulatedData;
            return this;
        }

        public Builder paymentNote(String paymentNote) {
            this.paymentNote = paymentNote;
            return this;
        }

        public CreatePaymentLinkRequest build() {
            return new CreatePaymentLinkRequest(this.idempotencyKey, this.description, this.quickPay, this.order, this.checkoutOptions, this.prePopulatedData, this.paymentNote);
        }
    }
}

