/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.TeamMember;
import java.util.Objects;

public class CreateTeamMemberRequest {
    private final String idempotencyKey;
    private final TeamMember teamMember;

    @JsonCreator
    public CreateTeamMemberRequest(@JsonProperty(value="idempotency_key") String idempotencyKey, @JsonProperty(value="team_member") TeamMember teamMember) {
        this.idempotencyKey = idempotencyKey;
        this.teamMember = teamMember;
    }

    @JsonGetter(value="idempotency_key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonGetter(value="team_member")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public TeamMember getTeamMember() {
        return this.teamMember;
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.teamMember);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateTeamMemberRequest)) {
            return false;
        }
        CreateTeamMemberRequest other = (CreateTeamMemberRequest)obj;
        return Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.teamMember, other.teamMember);
    }

    public String toString() {
        return "CreateTeamMemberRequest [idempotencyKey=" + this.idempotencyKey + ", teamMember=" + this.teamMember + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().idempotencyKey(this.getIdempotencyKey()).teamMember(this.getTeamMember());
        return builder;
    }

    public static class Builder {
        private String idempotencyKey;
        private TeamMember teamMember;

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder teamMember(TeamMember teamMember) {
            this.teamMember = teamMember;
            return this;
        }

        public CreateTeamMemberRequest build() {
            return new CreateTeamMemberRequest(this.idempotencyKey, this.teamMember);
        }
    }
}

