/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.TerminalRefund;
import java.util.Objects;

public class CreateTerminalRefundRequest {
    private final String idempotencyKey;
    private final TerminalRefund refund;

    @JsonCreator
    public CreateTerminalRefundRequest(@JsonProperty(value="idempotency_key") String idempotencyKey, @JsonProperty(value="refund") TerminalRefund refund) {
        this.idempotencyKey = idempotencyKey;
        this.refund = refund;
    }

    @JsonGetter(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonGetter(value="refund")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public TerminalRefund getRefund() {
        return this.refund;
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.refund);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateTerminalRefundRequest)) {
            return false;
        }
        CreateTerminalRefundRequest other = (CreateTerminalRefundRequest)obj;
        return Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.refund, other.refund);
    }

    public String toString() {
        return "CreateTerminalRefundRequest [idempotencyKey=" + this.idempotencyKey + ", refund=" + this.refund + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.idempotencyKey).refund(this.getRefund());
        return builder;
    }

    public static class Builder {
        private String idempotencyKey;
        private TerminalRefund refund;

        public Builder(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder refund(TerminalRefund refund) {
            this.refund = refund;
            return this;
        }

        public CreateTerminalRefundRequest build() {
            return new CreateTerminalRefundRequest(this.idempotencyKey, this.refund);
        }
    }
}

