/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.CustomAttributeDefinition;
import com.squareup.square.utilities.JsonValue;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class CustomAttribute {
    private final OptionalNullable<String> key;
    private final OptionalNullable<JsonValue> value;
    private final Integer version;
    private final String visibility;
    private final CustomAttributeDefinition definition;
    private final String updatedAt;
    private final String createdAt;

    @JsonCreator
    public CustomAttribute(@JsonProperty(value="key") String key, @JsonProperty(value="value") JsonValue value, @JsonProperty(value="version") Integer version, @JsonProperty(value="visibility") String visibility, @JsonProperty(value="definition") CustomAttributeDefinition definition, @JsonProperty(value="updated_at") String updatedAt, @JsonProperty(value="created_at") String createdAt) {
        this.key = OptionalNullable.of((Object)key);
        this.value = OptionalNullable.of((Object)((Object)value));
        this.version = version;
        this.visibility = visibility;
        this.definition = definition;
        this.updatedAt = updatedAt;
        this.createdAt = createdAt;
    }

    protected CustomAttribute(OptionalNullable<String> key, OptionalNullable<JsonValue> value, Integer version, String visibility, CustomAttributeDefinition definition, String updatedAt, String createdAt) {
        this.key = key;
        this.value = value;
        this.version = version;
        this.visibility = visibility;
        this.definition = definition;
        this.updatedAt = updatedAt;
        this.createdAt = createdAt;
    }

    @JsonGetter(value="key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetKey() {
        return this.key;
    }

    @JsonIgnore
    public String getKey() {
        return (String)OptionalNullable.getFrom(this.key);
    }

    @JsonGetter(value="value")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<JsonValue> internalGetValue() {
        return this.value;
    }

    @JsonIgnore
    public JsonValue getValue() {
        return (JsonValue)((Object)OptionalNullable.getFrom(this.value));
    }

    @JsonGetter(value="version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getVersion() {
        return this.version;
    }

    @JsonGetter(value="visibility")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getVisibility() {
        return this.visibility;
    }

    @JsonGetter(value="definition")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CustomAttributeDefinition getDefinition() {
        return this.definition;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value, this.version, this.visibility, this.definition, this.updatedAt, this.createdAt);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CustomAttribute)) {
            return false;
        }
        CustomAttribute other = (CustomAttribute)obj;
        return Objects.equals(this.key, other.key) && Objects.equals(this.value, other.value) && Objects.equals(this.version, other.version) && Objects.equals(this.visibility, other.visibility) && Objects.equals(this.definition, other.definition) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.createdAt, other.createdAt);
    }

    public String toString() {
        return "CustomAttribute [key=" + this.key + ", value=" + this.value + ", version=" + this.version + ", visibility=" + this.visibility + ", definition=" + this.definition + ", updatedAt=" + this.updatedAt + ", createdAt=" + this.createdAt + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().version(this.getVersion()).visibility(this.getVisibility()).definition(this.getDefinition()).updatedAt(this.getUpdatedAt()).createdAt(this.getCreatedAt());
        builder.key = this.internalGetKey();
        builder.value = this.internalGetValue();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> key;
        private OptionalNullable<JsonValue> value;
        private Integer version;
        private String visibility;
        private CustomAttributeDefinition definition;
        private String updatedAt;
        private String createdAt;

        public Builder key(String key) {
            this.key = OptionalNullable.of((Object)key);
            return this;
        }

        public Builder unsetKey() {
            this.key = null;
            return this;
        }

        public Builder value(JsonValue value) {
            this.value = OptionalNullable.of((Object)((Object)value));
            return this;
        }

        public Builder unsetValue() {
            this.value = null;
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        public Builder definition(CustomAttributeDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public CustomAttribute build() {
            return new CustomAttribute(this.key, this.value, this.version, this.visibility, this.definition, this.updatedAt, this.createdAt);
        }
    }
}

