/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.CustomerAddressFilter;
import com.squareup.square.models.CustomerTextFilter;
import com.squareup.square.models.FilterValue;
import com.squareup.square.models.FloatNumberRange;
import com.squareup.square.models.TimeRange;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class CustomerCustomAttributeFilterValue {
    private final CustomerTextFilter email;
    private final CustomerTextFilter phone;
    private final CustomerTextFilter text;
    private final FilterValue selection;
    private final TimeRange date;
    private final FloatNumberRange number;
    private final OptionalNullable<Boolean> mBoolean;
    private final CustomerAddressFilter address;

    @JsonCreator
    public CustomerCustomAttributeFilterValue(@JsonProperty(value="email") CustomerTextFilter email, @JsonProperty(value="phone") CustomerTextFilter phone, @JsonProperty(value="text") CustomerTextFilter text, @JsonProperty(value="selection") FilterValue selection, @JsonProperty(value="date") TimeRange date, @JsonProperty(value="number") FloatNumberRange number, @JsonProperty(value="boolean") Boolean mBoolean, @JsonProperty(value="address") CustomerAddressFilter address) {
        this.email = email;
        this.phone = phone;
        this.text = text;
        this.selection = selection;
        this.date = date;
        this.number = number;
        this.mBoolean = OptionalNullable.of((Object)mBoolean);
        this.address = address;
    }

    protected CustomerCustomAttributeFilterValue(CustomerTextFilter email, CustomerTextFilter phone, CustomerTextFilter text, FilterValue selection, TimeRange date, FloatNumberRange number, OptionalNullable<Boolean> mBoolean, CustomerAddressFilter address) {
        this.email = email;
        this.phone = phone;
        this.text = text;
        this.selection = selection;
        this.date = date;
        this.number = number;
        this.mBoolean = mBoolean;
        this.address = address;
    }

    @JsonGetter(value="email")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CustomerTextFilter getEmail() {
        return this.email;
    }

    @JsonGetter(value="phone")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CustomerTextFilter getPhone() {
        return this.phone;
    }

    @JsonGetter(value="text")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CustomerTextFilter getText() {
        return this.text;
    }

    @JsonGetter(value="selection")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public FilterValue getSelection() {
        return this.selection;
    }

    @JsonGetter(value="date")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public TimeRange getDate() {
        return this.date;
    }

    @JsonGetter(value="number")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public FloatNumberRange getNumber() {
        return this.number;
    }

    @JsonGetter(value="boolean")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetMBoolean() {
        return this.mBoolean;
    }

    @JsonIgnore
    public Boolean getMBoolean() {
        return (Boolean)OptionalNullable.getFrom(this.mBoolean);
    }

    @JsonGetter(value="address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CustomerAddressFilter getAddress() {
        return this.address;
    }

    public int hashCode() {
        return Objects.hash(this.email, this.phone, this.text, this.selection, this.date, this.number, this.mBoolean, this.address);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CustomerCustomAttributeFilterValue)) {
            return false;
        }
        CustomerCustomAttributeFilterValue other = (CustomerCustomAttributeFilterValue)obj;
        return Objects.equals(this.email, other.email) && Objects.equals(this.phone, other.phone) && Objects.equals(this.text, other.text) && Objects.equals(this.selection, other.selection) && Objects.equals(this.date, other.date) && Objects.equals(this.number, other.number) && Objects.equals(this.mBoolean, other.mBoolean) && Objects.equals(this.address, other.address);
    }

    public String toString() {
        return "CustomerCustomAttributeFilterValue [email=" + this.email + ", phone=" + this.phone + ", text=" + this.text + ", selection=" + this.selection + ", date=" + this.date + ", number=" + this.number + ", mBoolean=" + this.mBoolean + ", address=" + this.address + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().email(this.getEmail()).phone(this.getPhone()).text(this.getText()).selection(this.getSelection()).date(this.getDate()).number(this.getNumber()).address(this.getAddress());
        builder.mBoolean = this.internalGetMBoolean();
        return builder;
    }

    public static class Builder {
        private CustomerTextFilter email;
        private CustomerTextFilter phone;
        private CustomerTextFilter text;
        private FilterValue selection;
        private TimeRange date;
        private FloatNumberRange number;
        private OptionalNullable<Boolean> mBoolean;
        private CustomerAddressFilter address;

        public Builder email(CustomerTextFilter email) {
            this.email = email;
            return this;
        }

        public Builder phone(CustomerTextFilter phone) {
            this.phone = phone;
            return this;
        }

        public Builder text(CustomerTextFilter text) {
            this.text = text;
            return this;
        }

        public Builder selection(FilterValue selection) {
            this.selection = selection;
            return this;
        }

        public Builder date(TimeRange date) {
            this.date = date;
            return this;
        }

        public Builder number(FloatNumberRange number) {
            this.number = number;
            return this;
        }

        public Builder mBoolean(Boolean mBoolean) {
            this.mBoolean = OptionalNullable.of((Object)mBoolean);
            return this;
        }

        public Builder unsetMBoolean() {
            this.mBoolean = null;
            return this;
        }

        public Builder address(CustomerAddressFilter address) {
            this.address = address;
            return this;
        }

        public CustomerCustomAttributeFilterValue build() {
            return new CustomerCustomAttributeFilterValue(this.email, this.phone, this.text, this.selection, this.date, this.number, this.mBoolean, this.address);
        }
    }
}

