/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class CustomerDetails {
    private final OptionalNullable<Boolean> customerInitiated;
    private final OptionalNullable<Boolean> sellerKeyedIn;

    @JsonCreator
    public CustomerDetails(@JsonProperty(value="customer_initiated") Boolean customerInitiated, @JsonProperty(value="seller_keyed_in") Boolean sellerKeyedIn) {
        this.customerInitiated = OptionalNullable.of((Object)customerInitiated);
        this.sellerKeyedIn = OptionalNullable.of((Object)sellerKeyedIn);
    }

    protected CustomerDetails(OptionalNullable<Boolean> customerInitiated, OptionalNullable<Boolean> sellerKeyedIn) {
        this.customerInitiated = customerInitiated;
        this.sellerKeyedIn = sellerKeyedIn;
    }

    @JsonGetter(value="customer_initiated")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetCustomerInitiated() {
        return this.customerInitiated;
    }

    @JsonIgnore
    public Boolean getCustomerInitiated() {
        return (Boolean)OptionalNullable.getFrom(this.customerInitiated);
    }

    @JsonGetter(value="seller_keyed_in")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetSellerKeyedIn() {
        return this.sellerKeyedIn;
    }

    @JsonIgnore
    public Boolean getSellerKeyedIn() {
        return (Boolean)OptionalNullable.getFrom(this.sellerKeyedIn);
    }

    public int hashCode() {
        return Objects.hash(this.customerInitiated, this.sellerKeyedIn);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CustomerDetails)) {
            return false;
        }
        CustomerDetails other = (CustomerDetails)obj;
        return Objects.equals(this.customerInitiated, other.customerInitiated) && Objects.equals(this.sellerKeyedIn, other.sellerKeyedIn);
    }

    public String toString() {
        return "CustomerDetails [customerInitiated=" + this.customerInitiated + ", sellerKeyedIn=" + this.sellerKeyedIn + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.customerInitiated = this.internalGetCustomerInitiated();
        builder.sellerKeyedIn = this.internalGetSellerKeyedIn();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<Boolean> customerInitiated;
        private OptionalNullable<Boolean> sellerKeyedIn;

        public Builder customerInitiated(Boolean customerInitiated) {
            this.customerInitiated = OptionalNullable.of((Object)customerInitiated);
            return this;
        }

        public Builder unsetCustomerInitiated() {
            this.customerInitiated = null;
            return this;
        }

        public Builder sellerKeyedIn(Boolean sellerKeyedIn) {
            this.sellerKeyedIn = OptionalNullable.of((Object)sellerKeyedIn);
            return this;
        }

        public Builder unsetSellerKeyedIn() {
            this.sellerKeyedIn = null;
            return this;
        }

        public CustomerDetails build() {
            return new CustomerDetails(this.customerInitiated, this.sellerKeyedIn);
        }
    }
}

