/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.CustomerCreationSourceFilter;
import com.squareup.square.models.CustomerCustomAttributeFilters;
import com.squareup.square.models.CustomerTextFilter;
import com.squareup.square.models.FilterValue;
import com.squareup.square.models.TimeRange;
import java.util.Objects;

public class CustomerFilter {
    private final CustomerCreationSourceFilter creationSource;
    private final TimeRange createdAt;
    private final TimeRange updatedAt;
    private final CustomerTextFilter emailAddress;
    private final CustomerTextFilter phoneNumber;
    private final CustomerTextFilter referenceId;
    private final FilterValue groupIds;
    private final CustomerCustomAttributeFilters customAttribute;
    private final FilterValue segmentIds;

    @JsonCreator
    public CustomerFilter(@JsonProperty(value="creation_source") CustomerCreationSourceFilter creationSource, @JsonProperty(value="created_at") TimeRange createdAt, @JsonProperty(value="updated_at") TimeRange updatedAt, @JsonProperty(value="email_address") CustomerTextFilter emailAddress, @JsonProperty(value="phone_number") CustomerTextFilter phoneNumber, @JsonProperty(value="reference_id") CustomerTextFilter referenceId, @JsonProperty(value="group_ids") FilterValue groupIds, @JsonProperty(value="custom_attribute") CustomerCustomAttributeFilters customAttribute, @JsonProperty(value="segment_ids") FilterValue segmentIds) {
        this.creationSource = creationSource;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.emailAddress = emailAddress;
        this.phoneNumber = phoneNumber;
        this.referenceId = referenceId;
        this.groupIds = groupIds;
        this.customAttribute = customAttribute;
        this.segmentIds = segmentIds;
    }

    @JsonGetter(value="creation_source")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CustomerCreationSourceFilter getCreationSource() {
        return this.creationSource;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public TimeRange getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public TimeRange getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonGetter(value="email_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CustomerTextFilter getEmailAddress() {
        return this.emailAddress;
    }

    @JsonGetter(value="phone_number")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CustomerTextFilter getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonGetter(value="reference_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CustomerTextFilter getReferenceId() {
        return this.referenceId;
    }

    @JsonGetter(value="group_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public FilterValue getGroupIds() {
        return this.groupIds;
    }

    @JsonGetter(value="custom_attribute")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CustomerCustomAttributeFilters getCustomAttribute() {
        return this.customAttribute;
    }

    @JsonGetter(value="segment_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public FilterValue getSegmentIds() {
        return this.segmentIds;
    }

    public int hashCode() {
        return Objects.hash(this.creationSource, this.createdAt, this.updatedAt, this.emailAddress, this.phoneNumber, this.referenceId, this.groupIds, this.customAttribute, this.segmentIds);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CustomerFilter)) {
            return false;
        }
        CustomerFilter other = (CustomerFilter)obj;
        return Objects.equals(this.creationSource, other.creationSource) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.emailAddress, other.emailAddress) && Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.referenceId, other.referenceId) && Objects.equals(this.groupIds, other.groupIds) && Objects.equals(this.customAttribute, other.customAttribute) && Objects.equals(this.segmentIds, other.segmentIds);
    }

    public String toString() {
        return "CustomerFilter [creationSource=" + this.creationSource + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", emailAddress=" + this.emailAddress + ", phoneNumber=" + this.phoneNumber + ", referenceId=" + this.referenceId + ", groupIds=" + this.groupIds + ", customAttribute=" + this.customAttribute + ", segmentIds=" + this.segmentIds + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().creationSource(this.getCreationSource()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt()).emailAddress(this.getEmailAddress()).phoneNumber(this.getPhoneNumber()).referenceId(this.getReferenceId()).groupIds(this.getGroupIds()).customAttribute(this.getCustomAttribute()).segmentIds(this.getSegmentIds());
        return builder;
    }

    public static class Builder {
        private CustomerCreationSourceFilter creationSource;
        private TimeRange createdAt;
        private TimeRange updatedAt;
        private CustomerTextFilter emailAddress;
        private CustomerTextFilter phoneNumber;
        private CustomerTextFilter referenceId;
        private FilterValue groupIds;
        private CustomerCustomAttributeFilters customAttribute;
        private FilterValue segmentIds;

        public Builder creationSource(CustomerCreationSourceFilter creationSource) {
            this.creationSource = creationSource;
            return this;
        }

        public Builder createdAt(TimeRange createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(TimeRange updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder emailAddress(CustomerTextFilter emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder phoneNumber(CustomerTextFilter phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Builder referenceId(CustomerTextFilter referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public Builder groupIds(FilterValue groupIds) {
            this.groupIds = groupIds;
            return this;
        }

        public Builder customAttribute(CustomerCustomAttributeFilters customAttribute) {
            this.customAttribute = customAttribute;
            return this;
        }

        public Builder segmentIds(FilterValue segmentIds) {
            this.segmentIds = segmentIds;
            return this;
        }

        public CustomerFilter build() {
            return new CustomerFilter(this.creationSource, this.createdAt, this.updatedAt, this.emailAddress, this.phoneNumber, this.referenceId, this.groupIds, this.customAttribute, this.segmentIds);
        }
    }
}

