/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class CustomerTextFilter {
    private final OptionalNullable<String> exact;
    private final OptionalNullable<String> fuzzy;

    @JsonCreator
    public CustomerTextFilter(@JsonProperty(value="exact") String exact, @JsonProperty(value="fuzzy") String fuzzy) {
        this.exact = OptionalNullable.of((Object)exact);
        this.fuzzy = OptionalNullable.of((Object)fuzzy);
    }

    protected CustomerTextFilter(OptionalNullable<String> exact, OptionalNullable<String> fuzzy) {
        this.exact = exact;
        this.fuzzy = fuzzy;
    }

    @JsonGetter(value="exact")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetExact() {
        return this.exact;
    }

    @JsonIgnore
    public String getExact() {
        return (String)OptionalNullable.getFrom(this.exact);
    }

    @JsonGetter(value="fuzzy")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetFuzzy() {
        return this.fuzzy;
    }

    @JsonIgnore
    public String getFuzzy() {
        return (String)OptionalNullable.getFrom(this.fuzzy);
    }

    public int hashCode() {
        return Objects.hash(this.exact, this.fuzzy);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CustomerTextFilter)) {
            return false;
        }
        CustomerTextFilter other = (CustomerTextFilter)obj;
        return Objects.equals(this.exact, other.exact) && Objects.equals(this.fuzzy, other.fuzzy);
    }

    public String toString() {
        return "CustomerTextFilter [exact=" + this.exact + ", fuzzy=" + this.fuzzy + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.exact = this.internalGetExact();
        builder.fuzzy = this.internalGetFuzzy();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> exact;
        private OptionalNullable<String> fuzzy;

        public Builder exact(String exact) {
            this.exact = OptionalNullable.of((Object)exact);
            return this;
        }

        public Builder unsetExact() {
            this.exact = null;
            return this;
        }

        public Builder fuzzy(String fuzzy) {
            this.fuzzy = OptionalNullable.of((Object)fuzzy);
            return this;
        }

        public Builder unsetFuzzy() {
            this.fuzzy = null;
            return this;
        }

        public CustomerTextFilter build() {
            return new CustomerTextFilter(this.exact, this.fuzzy);
        }
    }
}

