/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class DateRange {
    private final OptionalNullable<String> startDate;
    private final OptionalNullable<String> endDate;

    @JsonCreator
    public DateRange(@JsonProperty(value="start_date") String startDate, @JsonProperty(value="end_date") String endDate) {
        this.startDate = OptionalNullable.of((Object)startDate);
        this.endDate = OptionalNullable.of((Object)endDate);
    }

    protected DateRange(OptionalNullable<String> startDate, OptionalNullable<String> endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
    }

    @JsonGetter(value="start_date")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetStartDate() {
        return this.startDate;
    }

    @JsonIgnore
    public String getStartDate() {
        return (String)OptionalNullable.getFrom(this.startDate);
    }

    @JsonGetter(value="end_date")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetEndDate() {
        return this.endDate;
    }

    @JsonIgnore
    public String getEndDate() {
        return (String)OptionalNullable.getFrom(this.endDate);
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.endDate);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DateRange)) {
            return false;
        }
        DateRange other = (DateRange)obj;
        return Objects.equals(this.startDate, other.startDate) && Objects.equals(this.endDate, other.endDate);
    }

    public String toString() {
        return "DateRange [startDate=" + this.startDate + ", endDate=" + this.endDate + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.startDate = this.internalGetStartDate();
        builder.endDate = this.internalGetEndDate();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> startDate;
        private OptionalNullable<String> endDate;

        public Builder startDate(String startDate) {
            this.startDate = OptionalNullable.of((Object)startDate);
            return this;
        }

        public Builder unsetStartDate() {
            this.startDate = null;
            return this;
        }

        public Builder endDate(String endDate) {
            this.endDate = OptionalNullable.of((Object)endDate);
            return this;
        }

        public Builder unsetEndDate() {
            this.endDate = null;
            return this;
        }

        public DateRange build() {
            return new DateRange(this.startDate, this.endDate);
        }
    }
}

