/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Component;
import com.squareup.square.models.DeviceAttributes;
import com.squareup.square.models.DeviceStatus;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class Device {
    private final String id;
    private final DeviceAttributes attributes;
    private final OptionalNullable<List<Component>> components;
    private final DeviceStatus status;

    @JsonCreator
    public Device(@JsonProperty(value="attributes") DeviceAttributes attributes, @JsonProperty(value="id") String id, @JsonProperty(value="components") List<Component> components, @JsonProperty(value="status") DeviceStatus status) {
        this.id = id;
        this.attributes = attributes;
        this.components = OptionalNullable.of(components);
        this.status = status;
    }

    protected Device(DeviceAttributes attributes, String id, OptionalNullable<List<Component>> components, DeviceStatus status) {
        this.id = id;
        this.attributes = attributes;
        this.components = components;
        this.status = status;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="attributes")
    public DeviceAttributes getAttributes() {
        return this.attributes;
    }

    @JsonGetter(value="components")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<Component>> internalGetComponents() {
        return this.components;
    }

    @JsonIgnore
    public List<Component> getComponents() {
        return (List)OptionalNullable.getFrom(this.components);
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public DeviceStatus getStatus() {
        return this.status;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.attributes, this.components, this.status);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Device)) {
            return false;
        }
        Device other = (Device)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.attributes, other.attributes) && Objects.equals(this.components, other.components) && Objects.equals(this.status, other.status);
    }

    public String toString() {
        return "Device [attributes=" + this.attributes + ", id=" + this.id + ", components=" + this.components + ", status=" + this.status + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.attributes).id(this.getId()).status(this.getStatus());
        builder.components = this.internalGetComponents();
        return builder;
    }

    public static class Builder {
        private DeviceAttributes attributes;
        private String id;
        private OptionalNullable<List<Component>> components;
        private DeviceStatus status;

        public Builder(DeviceAttributes attributes) {
            this.attributes = attributes;
        }

        public Builder attributes(DeviceAttributes attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder components(List<Component> components) {
            this.components = OptionalNullable.of(components);
            return this;
        }

        public Builder unsetComponents() {
            this.components = null;
            return this;
        }

        public Builder status(DeviceStatus status) {
            this.status = status;
            return this;
        }

        public Device build() {
            return new Device(this.attributes, this.id, this.components, this.status);
        }
    }
}

