/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class DeviceAttributes {
    private final String type;
    private final String manufacturer;
    private final OptionalNullable<String> model;
    private final OptionalNullable<String> name;
    private final OptionalNullable<String> manufacturersId;
    private final String updatedAt;
    private final String version;
    private final OptionalNullable<String> merchantToken;

    @JsonCreator
    public DeviceAttributes(@JsonProperty(value="type") String type, @JsonProperty(value="manufacturer") String manufacturer, @JsonProperty(value="model") String model, @JsonProperty(value="name") String name, @JsonProperty(value="manufacturers_id") String manufacturersId, @JsonProperty(value="updated_at") String updatedAt, @JsonProperty(value="version") String version, @JsonProperty(value="merchant_token") String merchantToken) {
        this.type = type;
        this.manufacturer = manufacturer;
        this.model = OptionalNullable.of((Object)model);
        this.name = OptionalNullable.of((Object)name);
        this.manufacturersId = OptionalNullable.of((Object)manufacturersId);
        this.updatedAt = updatedAt;
        this.version = version;
        this.merchantToken = OptionalNullable.of((Object)merchantToken);
    }

    protected DeviceAttributes(String type, String manufacturer, OptionalNullable<String> model, OptionalNullable<String> name, OptionalNullable<String> manufacturersId, String updatedAt, String version, OptionalNullable<String> merchantToken) {
        this.type = type;
        this.manufacturer = manufacturer;
        this.model = model;
        this.name = name;
        this.manufacturersId = manufacturersId;
        this.updatedAt = updatedAt;
        this.version = version;
        this.merchantToken = merchantToken;
    }

    @JsonGetter(value="type")
    public String getType() {
        return this.type;
    }

    @JsonGetter(value="manufacturer")
    public String getManufacturer() {
        return this.manufacturer;
    }

    @JsonGetter(value="model")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetModel() {
        return this.model;
    }

    @JsonIgnore
    public String getModel() {
        return (String)OptionalNullable.getFrom(this.model);
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetName() {
        return this.name;
    }

    @JsonIgnore
    public String getName() {
        return (String)OptionalNullable.getFrom(this.name);
    }

    @JsonGetter(value="manufacturers_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetManufacturersId() {
        return this.manufacturersId;
    }

    @JsonIgnore
    public String getManufacturersId() {
        return (String)OptionalNullable.getFrom(this.manufacturersId);
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonGetter(value="version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getVersion() {
        return this.version;
    }

    @JsonGetter(value="merchant_token")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetMerchantToken() {
        return this.merchantToken;
    }

    @JsonIgnore
    public String getMerchantToken() {
        return (String)OptionalNullable.getFrom(this.merchantToken);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.manufacturer, this.model, this.name, this.manufacturersId, this.updatedAt, this.version, this.merchantToken);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DeviceAttributes)) {
            return false;
        }
        DeviceAttributes other = (DeviceAttributes)obj;
        return Objects.equals(this.type, other.type) && Objects.equals(this.manufacturer, other.manufacturer) && Objects.equals(this.model, other.model) && Objects.equals(this.name, other.name) && Objects.equals(this.manufacturersId, other.manufacturersId) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.version, other.version) && Objects.equals(this.merchantToken, other.merchantToken);
    }

    public String toString() {
        return "DeviceAttributes [type=" + this.type + ", manufacturer=" + this.manufacturer + ", model=" + this.model + ", name=" + this.name + ", manufacturersId=" + this.manufacturersId + ", updatedAt=" + this.updatedAt + ", version=" + this.version + ", merchantToken=" + this.merchantToken + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.type, this.manufacturer).updatedAt(this.getUpdatedAt()).version(this.getVersion());
        builder.model = this.internalGetModel();
        builder.name = this.internalGetName();
        builder.manufacturersId = this.internalGetManufacturersId();
        builder.merchantToken = this.internalGetMerchantToken();
        return builder;
    }

    public static class Builder {
        private String type = "TERMINAL";
        private String manufacturer;
        private OptionalNullable<String> model;
        private OptionalNullable<String> name;
        private OptionalNullable<String> manufacturersId;
        private String updatedAt;
        private String version;
        private OptionalNullable<String> merchantToken;

        public Builder(String type, String manufacturer) {
            this.type = type;
            this.manufacturer = manufacturer;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            return this;
        }

        public Builder model(String model) {
            this.model = OptionalNullable.of((Object)model);
            return this;
        }

        public Builder unsetModel() {
            this.model = null;
            return this;
        }

        public Builder name(String name) {
            this.name = OptionalNullable.of((Object)name);
            return this;
        }

        public Builder unsetName() {
            this.name = null;
            return this;
        }

        public Builder manufacturersId(String manufacturersId) {
            this.manufacturersId = OptionalNullable.of((Object)manufacturersId);
            return this;
        }

        public Builder unsetManufacturersId() {
            this.manufacturersId = null;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder merchantToken(String merchantToken) {
            this.merchantToken = OptionalNullable.of((Object)merchantToken);
            return this;
        }

        public Builder unsetMerchantToken() {
            this.merchantToken = null;
            return this;
        }

        public DeviceAttributes build() {
            return new DeviceAttributes(this.type, this.manufacturer, this.model, this.name, this.manufacturersId, this.updatedAt, this.version, this.merchantToken);
        }
    }
}

