/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.TipSettings;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class DeviceCheckoutOptions {
    private final String deviceId;
    private final OptionalNullable<Boolean> skipReceiptScreen;
    private final OptionalNullable<Boolean> collectSignature;
    private final TipSettings tipSettings;
    private final OptionalNullable<Boolean> showItemizedCart;

    @JsonCreator
    public DeviceCheckoutOptions(@JsonProperty(value="device_id") String deviceId, @JsonProperty(value="skip_receipt_screen") Boolean skipReceiptScreen, @JsonProperty(value="collect_signature") Boolean collectSignature, @JsonProperty(value="tip_settings") TipSettings tipSettings, @JsonProperty(value="show_itemized_cart") Boolean showItemizedCart) {
        this.deviceId = deviceId;
        this.skipReceiptScreen = OptionalNullable.of((Object)skipReceiptScreen);
        this.collectSignature = OptionalNullable.of((Object)collectSignature);
        this.tipSettings = tipSettings;
        this.showItemizedCart = OptionalNullable.of((Object)showItemizedCart);
    }

    protected DeviceCheckoutOptions(String deviceId, OptionalNullable<Boolean> skipReceiptScreen, OptionalNullable<Boolean> collectSignature, TipSettings tipSettings, OptionalNullable<Boolean> showItemizedCart) {
        this.deviceId = deviceId;
        this.skipReceiptScreen = skipReceiptScreen;
        this.collectSignature = collectSignature;
        this.tipSettings = tipSettings;
        this.showItemizedCart = showItemizedCart;
    }

    @JsonGetter(value="device_id")
    public String getDeviceId() {
        return this.deviceId;
    }

    @JsonGetter(value="skip_receipt_screen")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetSkipReceiptScreen() {
        return this.skipReceiptScreen;
    }

    @JsonIgnore
    public Boolean getSkipReceiptScreen() {
        return (Boolean)OptionalNullable.getFrom(this.skipReceiptScreen);
    }

    @JsonGetter(value="collect_signature")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetCollectSignature() {
        return this.collectSignature;
    }

    @JsonIgnore
    public Boolean getCollectSignature() {
        return (Boolean)OptionalNullable.getFrom(this.collectSignature);
    }

    @JsonGetter(value="tip_settings")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public TipSettings getTipSettings() {
        return this.tipSettings;
    }

    @JsonGetter(value="show_itemized_cart")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetShowItemizedCart() {
        return this.showItemizedCart;
    }

    @JsonIgnore
    public Boolean getShowItemizedCart() {
        return (Boolean)OptionalNullable.getFrom(this.showItemizedCart);
    }

    public int hashCode() {
        return Objects.hash(this.deviceId, this.skipReceiptScreen, this.collectSignature, this.tipSettings, this.showItemizedCart);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DeviceCheckoutOptions)) {
            return false;
        }
        DeviceCheckoutOptions other = (DeviceCheckoutOptions)obj;
        return Objects.equals(this.deviceId, other.deviceId) && Objects.equals(this.skipReceiptScreen, other.skipReceiptScreen) && Objects.equals(this.collectSignature, other.collectSignature) && Objects.equals(this.tipSettings, other.tipSettings) && Objects.equals(this.showItemizedCart, other.showItemizedCart);
    }

    public String toString() {
        return "DeviceCheckoutOptions [deviceId=" + this.deviceId + ", skipReceiptScreen=" + this.skipReceiptScreen + ", collectSignature=" + this.collectSignature + ", tipSettings=" + this.tipSettings + ", showItemizedCart=" + this.showItemizedCart + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.deviceId).tipSettings(this.getTipSettings());
        builder.skipReceiptScreen = this.internalGetSkipReceiptScreen();
        builder.collectSignature = this.internalGetCollectSignature();
        builder.showItemizedCart = this.internalGetShowItemizedCart();
        return builder;
    }

    public static class Builder {
        private String deviceId;
        private OptionalNullable<Boolean> skipReceiptScreen;
        private OptionalNullable<Boolean> collectSignature;
        private TipSettings tipSettings;
        private OptionalNullable<Boolean> showItemizedCart;

        public Builder(String deviceId) {
            this.deviceId = deviceId;
        }

        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public Builder skipReceiptScreen(Boolean skipReceiptScreen) {
            this.skipReceiptScreen = OptionalNullable.of((Object)skipReceiptScreen);
            return this;
        }

        public Builder unsetSkipReceiptScreen() {
            this.skipReceiptScreen = null;
            return this;
        }

        public Builder collectSignature(Boolean collectSignature) {
            this.collectSignature = OptionalNullable.of((Object)collectSignature);
            return this;
        }

        public Builder unsetCollectSignature() {
            this.collectSignature = null;
            return this;
        }

        public Builder tipSettings(TipSettings tipSettings) {
            this.tipSettings = tipSettings;
            return this;
        }

        public Builder showItemizedCart(Boolean showItemizedCart) {
            this.showItemizedCart = OptionalNullable.of((Object)showItemizedCart);
            return this;
        }

        public Builder unsetShowItemizedCart() {
            this.showItemizedCart = null;
            return this;
        }

        public DeviceCheckoutOptions build() {
            return new DeviceCheckoutOptions(this.deviceId, this.skipReceiptScreen, this.collectSignature, this.tipSettings, this.showItemizedCart);
        }
    }
}

