/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class DeviceComponentDetailsApplicationDetails {
    private final String applicationType;
    private final String version;
    private final OptionalNullable<String> sessionLocation;
    private final OptionalNullable<String> deviceCodeId;

    @JsonCreator
    public DeviceComponentDetailsApplicationDetails(@JsonProperty(value="application_type") String applicationType, @JsonProperty(value="version") String version, @JsonProperty(value="session_location") String sessionLocation, @JsonProperty(value="device_code_id") String deviceCodeId) {
        this.applicationType = applicationType;
        this.version = version;
        this.sessionLocation = OptionalNullable.of((Object)sessionLocation);
        this.deviceCodeId = OptionalNullable.of((Object)deviceCodeId);
    }

    protected DeviceComponentDetailsApplicationDetails(String applicationType, String version, OptionalNullable<String> sessionLocation, OptionalNullable<String> deviceCodeId) {
        this.applicationType = applicationType;
        this.version = version;
        this.sessionLocation = sessionLocation;
        this.deviceCodeId = deviceCodeId;
    }

    @JsonGetter(value="application_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getApplicationType() {
        return this.applicationType;
    }

    @JsonGetter(value="version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getVersion() {
        return this.version;
    }

    @JsonGetter(value="session_location")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetSessionLocation() {
        return this.sessionLocation;
    }

    @JsonIgnore
    public String getSessionLocation() {
        return (String)OptionalNullable.getFrom(this.sessionLocation);
    }

    @JsonGetter(value="device_code_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetDeviceCodeId() {
        return this.deviceCodeId;
    }

    @JsonIgnore
    public String getDeviceCodeId() {
        return (String)OptionalNullable.getFrom(this.deviceCodeId);
    }

    public int hashCode() {
        return Objects.hash(this.applicationType, this.version, this.sessionLocation, this.deviceCodeId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DeviceComponentDetailsApplicationDetails)) {
            return false;
        }
        DeviceComponentDetailsApplicationDetails other = (DeviceComponentDetailsApplicationDetails)obj;
        return Objects.equals(this.applicationType, other.applicationType) && Objects.equals(this.version, other.version) && Objects.equals(this.sessionLocation, other.sessionLocation) && Objects.equals(this.deviceCodeId, other.deviceCodeId);
    }

    public String toString() {
        return "DeviceComponentDetailsApplicationDetails [applicationType=" + this.applicationType + ", version=" + this.version + ", sessionLocation=" + this.sessionLocation + ", deviceCodeId=" + this.deviceCodeId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().applicationType(this.getApplicationType()).version(this.getVersion());
        builder.sessionLocation = this.internalGetSessionLocation();
        builder.deviceCodeId = this.internalGetDeviceCodeId();
        return builder;
    }

    public static class Builder {
        private String applicationType;
        private String version;
        private OptionalNullable<String> sessionLocation;
        private OptionalNullable<String> deviceCodeId;

        public Builder applicationType(String applicationType) {
            this.applicationType = applicationType;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder sessionLocation(String sessionLocation) {
            this.sessionLocation = OptionalNullable.of((Object)sessionLocation);
            return this;
        }

        public Builder unsetSessionLocation() {
            this.sessionLocation = null;
            return this;
        }

        public Builder deviceCodeId(String deviceCodeId) {
            this.deviceCodeId = OptionalNullable.of((Object)deviceCodeId);
            return this;
        }

        public Builder unsetDeviceCodeId() {
            this.deviceCodeId = null;
            return this;
        }

        public DeviceComponentDetailsApplicationDetails build() {
            return new DeviceComponentDetailsApplicationDetails(this.applicationType, this.version, this.sessionLocation, this.deviceCodeId);
        }
    }
}

