/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class DeviceComponentDetailsBatteryDetails {
    private final OptionalNullable<Integer> visiblePercent;
    private final String externalPower;

    @JsonCreator
    public DeviceComponentDetailsBatteryDetails(@JsonProperty(value="visible_percent") Integer visiblePercent, @JsonProperty(value="external_power") String externalPower) {
        this.visiblePercent = OptionalNullable.of((Object)visiblePercent);
        this.externalPower = externalPower;
    }

    protected DeviceComponentDetailsBatteryDetails(OptionalNullable<Integer> visiblePercent, String externalPower) {
        this.visiblePercent = visiblePercent;
        this.externalPower = externalPower;
    }

    @JsonGetter(value="visible_percent")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Integer> internalGetVisiblePercent() {
        return this.visiblePercent;
    }

    @JsonIgnore
    public Integer getVisiblePercent() {
        return (Integer)OptionalNullable.getFrom(this.visiblePercent);
    }

    @JsonGetter(value="external_power")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getExternalPower() {
        return this.externalPower;
    }

    public int hashCode() {
        return Objects.hash(this.visiblePercent, this.externalPower);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DeviceComponentDetailsBatteryDetails)) {
            return false;
        }
        DeviceComponentDetailsBatteryDetails other = (DeviceComponentDetailsBatteryDetails)obj;
        return Objects.equals(this.visiblePercent, other.visiblePercent) && Objects.equals(this.externalPower, other.externalPower);
    }

    public String toString() {
        return "DeviceComponentDetailsBatteryDetails [visiblePercent=" + this.visiblePercent + ", externalPower=" + this.externalPower + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().externalPower(this.getExternalPower());
        builder.visiblePercent = this.internalGetVisiblePercent();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<Integer> visiblePercent;
        private String externalPower;

        public Builder visiblePercent(Integer visiblePercent) {
            this.visiblePercent = OptionalNullable.of((Object)visiblePercent);
            return this;
        }

        public Builder unsetVisiblePercent() {
            this.visiblePercent = null;
            return this;
        }

        public Builder externalPower(String externalPower) {
            this.externalPower = externalPower;
            return this;
        }

        public DeviceComponentDetailsBatteryDetails build() {
            return new DeviceComponentDetailsBatteryDetails(this.visiblePercent, this.externalPower);
        }
    }
}

