/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class DeviceDetails {
    private final OptionalNullable<String> deviceId;
    private final OptionalNullable<String> deviceInstallationId;
    private final OptionalNullable<String> deviceName;

    @JsonCreator
    public DeviceDetails(@JsonProperty(value="device_id") String deviceId, @JsonProperty(value="device_installation_id") String deviceInstallationId, @JsonProperty(value="device_name") String deviceName) {
        this.deviceId = OptionalNullable.of((Object)deviceId);
        this.deviceInstallationId = OptionalNullable.of((Object)deviceInstallationId);
        this.deviceName = OptionalNullable.of((Object)deviceName);
    }

    protected DeviceDetails(OptionalNullable<String> deviceId, OptionalNullable<String> deviceInstallationId, OptionalNullable<String> deviceName) {
        this.deviceId = deviceId;
        this.deviceInstallationId = deviceInstallationId;
        this.deviceName = deviceName;
    }

    @JsonGetter(value="device_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetDeviceId() {
        return this.deviceId;
    }

    @JsonIgnore
    public String getDeviceId() {
        return (String)OptionalNullable.getFrom(this.deviceId);
    }

    @JsonGetter(value="device_installation_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetDeviceInstallationId() {
        return this.deviceInstallationId;
    }

    @JsonIgnore
    public String getDeviceInstallationId() {
        return (String)OptionalNullable.getFrom(this.deviceInstallationId);
    }

    @JsonGetter(value="device_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetDeviceName() {
        return this.deviceName;
    }

    @JsonIgnore
    public String getDeviceName() {
        return (String)OptionalNullable.getFrom(this.deviceName);
    }

    public int hashCode() {
        return Objects.hash(this.deviceId, this.deviceInstallationId, this.deviceName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DeviceDetails)) {
            return false;
        }
        DeviceDetails other = (DeviceDetails)obj;
        return Objects.equals(this.deviceId, other.deviceId) && Objects.equals(this.deviceInstallationId, other.deviceInstallationId) && Objects.equals(this.deviceName, other.deviceName);
    }

    public String toString() {
        return "DeviceDetails [deviceId=" + this.deviceId + ", deviceInstallationId=" + this.deviceInstallationId + ", deviceName=" + this.deviceName + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.deviceId = this.internalGetDeviceId();
        builder.deviceInstallationId = this.internalGetDeviceInstallationId();
        builder.deviceName = this.internalGetDeviceName();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> deviceId;
        private OptionalNullable<String> deviceInstallationId;
        private OptionalNullable<String> deviceName;

        public Builder deviceId(String deviceId) {
            this.deviceId = OptionalNullable.of((Object)deviceId);
            return this;
        }

        public Builder unsetDeviceId() {
            this.deviceId = null;
            return this;
        }

        public Builder deviceInstallationId(String deviceInstallationId) {
            this.deviceInstallationId = OptionalNullable.of((Object)deviceInstallationId);
            return this;
        }

        public Builder unsetDeviceInstallationId() {
            this.deviceInstallationId = null;
            return this;
        }

        public Builder deviceName(String deviceName) {
            this.deviceName = OptionalNullable.of((Object)deviceName);
            return this;
        }

        public Builder unsetDeviceName() {
            this.deviceName = null;
            return this;
        }

        public DeviceDetails build() {
            return new DeviceDetails(this.deviceId, this.deviceInstallationId, this.deviceName);
        }
    }
}

