/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.CashAppDetails;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class DigitalWalletDetails {
    private final OptionalNullable<String> status;
    private final OptionalNullable<String> brand;
    private final CashAppDetails cashAppDetails;

    @JsonCreator
    public DigitalWalletDetails(@JsonProperty(value="status") String status, @JsonProperty(value="brand") String brand, @JsonProperty(value="cash_app_details") CashAppDetails cashAppDetails) {
        this.status = OptionalNullable.of((Object)status);
        this.brand = OptionalNullable.of((Object)brand);
        this.cashAppDetails = cashAppDetails;
    }

    protected DigitalWalletDetails(OptionalNullable<String> status, OptionalNullable<String> brand, CashAppDetails cashAppDetails) {
        this.status = status;
        this.brand = brand;
        this.cashAppDetails = cashAppDetails;
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetStatus() {
        return this.status;
    }

    @JsonIgnore
    public String getStatus() {
        return (String)OptionalNullable.getFrom(this.status);
    }

    @JsonGetter(value="brand")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetBrand() {
        return this.brand;
    }

    @JsonIgnore
    public String getBrand() {
        return (String)OptionalNullable.getFrom(this.brand);
    }

    @JsonGetter(value="cash_app_details")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CashAppDetails getCashAppDetails() {
        return this.cashAppDetails;
    }

    public int hashCode() {
        return Objects.hash(this.status, this.brand, this.cashAppDetails);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DigitalWalletDetails)) {
            return false;
        }
        DigitalWalletDetails other = (DigitalWalletDetails)obj;
        return Objects.equals(this.status, other.status) && Objects.equals(this.brand, other.brand) && Objects.equals(this.cashAppDetails, other.cashAppDetails);
    }

    public String toString() {
        return "DigitalWalletDetails [status=" + this.status + ", brand=" + this.brand + ", cashAppDetails=" + this.cashAppDetails + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().cashAppDetails(this.getCashAppDetails());
        builder.status = this.internalGetStatus();
        builder.brand = this.internalGetBrand();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> status;
        private OptionalNullable<String> brand;
        private CashAppDetails cashAppDetails;

        public Builder status(String status) {
            this.status = OptionalNullable.of((Object)status);
            return this;
        }

        public Builder unsetStatus() {
            this.status = null;
            return this;
        }

        public Builder brand(String brand) {
            this.brand = OptionalNullable.of((Object)brand);
            return this;
        }

        public Builder unsetBrand() {
            this.brand = null;
            return this;
        }

        public Builder cashAppDetails(CashAppDetails cashAppDetails) {
            this.cashAppDetails = cashAppDetails;
            return this;
        }

        public DigitalWalletDetails build() {
            return new DigitalWalletDetails(this.status, this.brand, this.cashAppDetails);
        }
    }
}

