/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.TerminalCheckout;
import java.util.List;
import java.util.Objects;

public class DismissTerminalCheckoutResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final TerminalCheckout checkout;

    @JsonCreator
    public DismissTerminalCheckoutResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="checkout") TerminalCheckout checkout) {
        this.errors = errors;
        this.checkout = checkout;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="checkout")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public TerminalCheckout getCheckout() {
        return this.checkout;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.checkout);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DismissTerminalCheckoutResponse)) {
            return false;
        }
        DismissTerminalCheckoutResponse other = (DismissTerminalCheckoutResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.checkout, other.checkout);
    }

    public String toString() {
        return "DismissTerminalCheckoutResponse [errors=" + this.errors + ", checkout=" + this.checkout + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).checkout(this.getCheckout());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private TerminalCheckout checkout;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder checkout(TerminalCheckout checkout) {
            this.checkout = checkout;
            return this;
        }

        public DismissTerminalCheckoutResponse build() {
            DismissTerminalCheckoutResponse model = new DismissTerminalCheckoutResponse(this.errors, this.checkout);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

