/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.EventData;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class Event {
    private final OptionalNullable<String> merchantId;
    private final OptionalNullable<String> locationId;
    private final OptionalNullable<String> type;
    private final OptionalNullable<String> eventId;
    private final String createdAt;
    private final EventData data;

    @JsonCreator
    public Event(@JsonProperty(value="merchant_id") String merchantId, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="type") String type, @JsonProperty(value="event_id") String eventId, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="data") EventData data) {
        this.merchantId = OptionalNullable.of((Object)merchantId);
        this.locationId = OptionalNullable.of((Object)locationId);
        this.type = OptionalNullable.of((Object)type);
        this.eventId = OptionalNullable.of((Object)eventId);
        this.createdAt = createdAt;
        this.data = data;
    }

    protected Event(OptionalNullable<String> merchantId, OptionalNullable<String> locationId, OptionalNullable<String> type, OptionalNullable<String> eventId, String createdAt, EventData data) {
        this.merchantId = merchantId;
        this.locationId = locationId;
        this.type = type;
        this.eventId = eventId;
        this.createdAt = createdAt;
        this.data = data;
    }

    @JsonGetter(value="merchant_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetMerchantId() {
        return this.merchantId;
    }

    @JsonIgnore
    public String getMerchantId() {
        return (String)OptionalNullable.getFrom(this.merchantId);
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetLocationId() {
        return this.locationId;
    }

    @JsonIgnore
    public String getLocationId() {
        return (String)OptionalNullable.getFrom(this.locationId);
    }

    @JsonGetter(value="type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetType() {
        return this.type;
    }

    @JsonIgnore
    public String getType() {
        return (String)OptionalNullable.getFrom(this.type);
    }

    @JsonGetter(value="event_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetEventId() {
        return this.eventId;
    }

    @JsonIgnore
    public String getEventId() {
        return (String)OptionalNullable.getFrom(this.eventId);
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="data")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public EventData getData() {
        return this.data;
    }

    public int hashCode() {
        return Objects.hash(this.merchantId, this.locationId, this.type, this.eventId, this.createdAt, this.data);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event)obj;
        return Objects.equals(this.merchantId, other.merchantId) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.type, other.type) && Objects.equals(this.eventId, other.eventId) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.data, other.data);
    }

    public String toString() {
        return "Event [merchantId=" + this.merchantId + ", locationId=" + this.locationId + ", type=" + this.type + ", eventId=" + this.eventId + ", createdAt=" + this.createdAt + ", data=" + this.data + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().createdAt(this.getCreatedAt()).data(this.getData());
        builder.merchantId = this.internalGetMerchantId();
        builder.locationId = this.internalGetLocationId();
        builder.type = this.internalGetType();
        builder.eventId = this.internalGetEventId();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> merchantId;
        private OptionalNullable<String> locationId;
        private OptionalNullable<String> type;
        private OptionalNullable<String> eventId;
        private String createdAt;
        private EventData data;

        public Builder merchantId(String merchantId) {
            this.merchantId = OptionalNullable.of((Object)merchantId);
            return this;
        }

        public Builder unsetMerchantId() {
            this.merchantId = null;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = OptionalNullable.of((Object)locationId);
            return this;
        }

        public Builder unsetLocationId() {
            this.locationId = null;
            return this;
        }

        public Builder type(String type) {
            this.type = OptionalNullable.of((Object)type);
            return this;
        }

        public Builder unsetType() {
            this.type = null;
            return this;
        }

        public Builder eventId(String eventId) {
            this.eventId = OptionalNullable.of((Object)eventId);
            return this;
        }

        public Builder unsetEventId() {
            this.eventId = null;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder data(EventData data) {
            this.data = data;
            return this;
        }

        public Event build() {
            return new Event(this.merchantId, this.locationId, this.type, this.eventId, this.createdAt, this.data);
        }
    }
}

