/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class EventTypeMetadata {
    private final String eventType;
    private final String apiVersionIntroduced;
    private final String releaseStatus;

    @JsonCreator
    public EventTypeMetadata(@JsonProperty(value="event_type") String eventType, @JsonProperty(value="api_version_introduced") String apiVersionIntroduced, @JsonProperty(value="release_status") String releaseStatus) {
        this.eventType = eventType;
        this.apiVersionIntroduced = apiVersionIntroduced;
        this.releaseStatus = releaseStatus;
    }

    @JsonGetter(value="event_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEventType() {
        return this.eventType;
    }

    @JsonGetter(value="api_version_introduced")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getApiVersionIntroduced() {
        return this.apiVersionIntroduced;
    }

    @JsonGetter(value="release_status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReleaseStatus() {
        return this.releaseStatus;
    }

    public int hashCode() {
        return Objects.hash(this.eventType, this.apiVersionIntroduced, this.releaseStatus);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EventTypeMetadata)) {
            return false;
        }
        EventTypeMetadata other = (EventTypeMetadata)obj;
        return Objects.equals(this.eventType, other.eventType) && Objects.equals(this.apiVersionIntroduced, other.apiVersionIntroduced) && Objects.equals(this.releaseStatus, other.releaseStatus);
    }

    public String toString() {
        return "EventTypeMetadata [eventType=" + this.eventType + ", apiVersionIntroduced=" + this.apiVersionIntroduced + ", releaseStatus=" + this.releaseStatus + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().eventType(this.getEventType()).apiVersionIntroduced(this.getApiVersionIntroduced()).releaseStatus(this.getReleaseStatus());
        return builder;
    }

    public static class Builder {
        private String eventType;
        private String apiVersionIntroduced;
        private String releaseStatus;

        public Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public Builder apiVersionIntroduced(String apiVersionIntroduced) {
            this.apiVersionIntroduced = apiVersionIntroduced;
            return this;
        }

        public Builder releaseStatus(String releaseStatus) {
            this.releaseStatus = releaseStatus;
            return this;
        }

        public EventTypeMetadata build() {
            return new EventTypeMetadata(this.eventType, this.apiVersionIntroduced, this.releaseStatus);
        }
    }
}

