/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Map;
import java.util.Objects;

public class FulfillmentFulfillmentEntry {
    private final OptionalNullable<String> uid;
    private final String lineItemUid;
    private final String quantity;
    private final OptionalNullable<Map<String, String>> metadata;

    @JsonCreator
    public FulfillmentFulfillmentEntry(@JsonProperty(value="line_item_uid") String lineItemUid, @JsonProperty(value="quantity") String quantity, @JsonProperty(value="uid") String uid, @JsonProperty(value="metadata") Map<String, String> metadata) {
        this.uid = OptionalNullable.of((Object)uid);
        this.lineItemUid = lineItemUid;
        this.quantity = quantity;
        this.metadata = OptionalNullable.of(metadata);
    }

    protected FulfillmentFulfillmentEntry(String lineItemUid, String quantity, OptionalNullable<String> uid, OptionalNullable<Map<String, String>> metadata) {
        this.uid = uid;
        this.lineItemUid = lineItemUid;
        this.quantity = quantity;
        this.metadata = metadata;
    }

    @JsonGetter(value="uid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetUid() {
        return this.uid;
    }

    @JsonIgnore
    public String getUid() {
        return (String)OptionalNullable.getFrom(this.uid);
    }

    @JsonGetter(value="line_item_uid")
    public String getLineItemUid() {
        return this.lineItemUid;
    }

    @JsonGetter(value="quantity")
    public String getQuantity() {
        return this.quantity;
    }

    @JsonGetter(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Map<String, String>> internalGetMetadata() {
        return this.metadata;
    }

    @JsonIgnore
    public Map<String, String> getMetadata() {
        return (Map)OptionalNullable.getFrom(this.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.lineItemUid, this.quantity, this.metadata);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FulfillmentFulfillmentEntry)) {
            return false;
        }
        FulfillmentFulfillmentEntry other = (FulfillmentFulfillmentEntry)obj;
        return Objects.equals(this.uid, other.uid) && Objects.equals(this.lineItemUid, other.lineItemUid) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.metadata, other.metadata);
    }

    public String toString() {
        return "FulfillmentFulfillmentEntry [lineItemUid=" + this.lineItemUid + ", quantity=" + this.quantity + ", uid=" + this.uid + ", metadata=" + this.metadata + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.lineItemUid, this.quantity);
        builder.uid = this.internalGetUid();
        builder.metadata = this.internalGetMetadata();
        return builder;
    }

    public static class Builder {
        private String lineItemUid;
        private String quantity;
        private OptionalNullable<String> uid;
        private OptionalNullable<Map<String, String>> metadata;

        public Builder(String lineItemUid, String quantity) {
            this.lineItemUid = lineItemUid;
            this.quantity = quantity;
        }

        public Builder lineItemUid(String lineItemUid) {
            this.lineItemUid = lineItemUid;
            return this;
        }

        public Builder quantity(String quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder uid(String uid) {
            this.uid = OptionalNullable.of((Object)uid);
            return this;
        }

        public Builder unsetUid() {
            this.uid = null;
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = OptionalNullable.of(metadata);
            return this;
        }

        public Builder unsetMetadata() {
            this.metadata = null;
            return this;
        }

        public FulfillmentFulfillmentEntry build() {
            return new FulfillmentFulfillmentEntry(this.lineItemUid, this.quantity, this.uid, this.metadata);
        }
    }
}

