/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Address;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class FulfillmentRecipient {
    private final OptionalNullable<String> customerId;
    private final OptionalNullable<String> displayName;
    private final OptionalNullable<String> emailAddress;
    private final OptionalNullable<String> phoneNumber;
    private final Address address;

    @JsonCreator
    public FulfillmentRecipient(@JsonProperty(value="customer_id") String customerId, @JsonProperty(value="display_name") String displayName, @JsonProperty(value="email_address") String emailAddress, @JsonProperty(value="phone_number") String phoneNumber, @JsonProperty(value="address") Address address) {
        this.customerId = OptionalNullable.of((Object)customerId);
        this.displayName = OptionalNullable.of((Object)displayName);
        this.emailAddress = OptionalNullable.of((Object)emailAddress);
        this.phoneNumber = OptionalNullable.of((Object)phoneNumber);
        this.address = address;
    }

    protected FulfillmentRecipient(OptionalNullable<String> customerId, OptionalNullable<String> displayName, OptionalNullable<String> emailAddress, OptionalNullable<String> phoneNumber, Address address) {
        this.customerId = customerId;
        this.displayName = displayName;
        this.emailAddress = emailAddress;
        this.phoneNumber = phoneNumber;
        this.address = address;
    }

    @JsonGetter(value="customer_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCustomerId() {
        return this.customerId;
    }

    @JsonIgnore
    public String getCustomerId() {
        return (String)OptionalNullable.getFrom(this.customerId);
    }

    @JsonGetter(value="display_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetDisplayName() {
        return this.displayName;
    }

    @JsonIgnore
    public String getDisplayName() {
        return (String)OptionalNullable.getFrom(this.displayName);
    }

    @JsonGetter(value="email_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetEmailAddress() {
        return this.emailAddress;
    }

    @JsonIgnore
    public String getEmailAddress() {
        return (String)OptionalNullable.getFrom(this.emailAddress);
    }

    @JsonGetter(value="phone_number")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonIgnore
    public String getPhoneNumber() {
        return (String)OptionalNullable.getFrom(this.phoneNumber);
    }

    @JsonGetter(value="address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Address getAddress() {
        return this.address;
    }

    public int hashCode() {
        return Objects.hash(this.customerId, this.displayName, this.emailAddress, this.phoneNumber, this.address);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FulfillmentRecipient)) {
            return false;
        }
        FulfillmentRecipient other = (FulfillmentRecipient)obj;
        return Objects.equals(this.customerId, other.customerId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.emailAddress, other.emailAddress) && Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.address, other.address);
    }

    public String toString() {
        return "FulfillmentRecipient [customerId=" + this.customerId + ", displayName=" + this.displayName + ", emailAddress=" + this.emailAddress + ", phoneNumber=" + this.phoneNumber + ", address=" + this.address + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().address(this.getAddress());
        builder.customerId = this.internalGetCustomerId();
        builder.displayName = this.internalGetDisplayName();
        builder.emailAddress = this.internalGetEmailAddress();
        builder.phoneNumber = this.internalGetPhoneNumber();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> customerId;
        private OptionalNullable<String> displayName;
        private OptionalNullable<String> emailAddress;
        private OptionalNullable<String> phoneNumber;
        private Address address;

        public Builder customerId(String customerId) {
            this.customerId = OptionalNullable.of((Object)customerId);
            return this;
        }

        public Builder unsetCustomerId() {
            this.customerId = null;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = OptionalNullable.of((Object)displayName);
            return this;
        }

        public Builder unsetDisplayName() {
            this.displayName = null;
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = OptionalNullable.of((Object)emailAddress);
            return this;
        }

        public Builder unsetEmailAddress() {
            this.emailAddress = null;
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = OptionalNullable.of((Object)phoneNumber);
            return this;
        }

        public Builder unsetPhoneNumber() {
            this.phoneNumber = null;
            return this;
        }

        public Builder address(Address address) {
            this.address = address;
            return this;
        }

        public FulfillmentRecipient build() {
            return new FulfillmentRecipient(this.customerId, this.displayName, this.emailAddress, this.phoneNumber, this.address);
        }
    }
}

