/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.TeamMemberWage;
import java.util.List;
import java.util.Objects;

public class GetTeamMemberWageResponse {
    private HttpContext httpContext;
    private final TeamMemberWage teamMemberWage;
    private final List<Error> errors;

    @JsonCreator
    public GetTeamMemberWageResponse(@JsonProperty(value="team_member_wage") TeamMemberWage teamMemberWage, @JsonProperty(value="errors") List<Error> errors) {
        this.teamMemberWage = teamMemberWage;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="team_member_wage")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public TeamMemberWage getTeamMemberWage() {
        return this.teamMemberWage;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.teamMemberWage, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GetTeamMemberWageResponse)) {
            return false;
        }
        GetTeamMemberWageResponse other = (GetTeamMemberWageResponse)obj;
        return Objects.equals(this.teamMemberWage, other.teamMemberWage) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "GetTeamMemberWageResponse [teamMemberWage=" + this.teamMemberWage + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().teamMemberWage(this.getTeamMemberWage()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private TeamMemberWage teamMemberWage;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder teamMemberWage(TeamMemberWage teamMemberWage) {
            this.teamMemberWage = teamMemberWage;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public GetTeamMemberWageResponse build() {
            GetTeamMemberWageResponse model = new GetTeamMemberWageResponse(this.teamMemberWage, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

