/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class GiftCardActivityActivate {
    private final Money amountMoney;
    private final OptionalNullable<String> orderId;
    private final OptionalNullable<String> lineItemUid;
    private final OptionalNullable<String> referenceId;
    private final OptionalNullable<List<String>> buyerPaymentInstrumentIds;

    @JsonCreator
    public GiftCardActivityActivate(@JsonProperty(value="amount_money") Money amountMoney, @JsonProperty(value="order_id") String orderId, @JsonProperty(value="line_item_uid") String lineItemUid, @JsonProperty(value="reference_id") String referenceId, @JsonProperty(value="buyer_payment_instrument_ids") List<String> buyerPaymentInstrumentIds) {
        this.amountMoney = amountMoney;
        this.orderId = OptionalNullable.of((Object)orderId);
        this.lineItemUid = OptionalNullable.of((Object)lineItemUid);
        this.referenceId = OptionalNullable.of((Object)referenceId);
        this.buyerPaymentInstrumentIds = OptionalNullable.of(buyerPaymentInstrumentIds);
    }

    protected GiftCardActivityActivate(Money amountMoney, OptionalNullable<String> orderId, OptionalNullable<String> lineItemUid, OptionalNullable<String> referenceId, OptionalNullable<List<String>> buyerPaymentInstrumentIds) {
        this.amountMoney = amountMoney;
        this.orderId = orderId;
        this.lineItemUid = lineItemUid;
        this.referenceId = referenceId;
        this.buyerPaymentInstrumentIds = buyerPaymentInstrumentIds;
    }

    @JsonGetter(value="amount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonGetter(value="order_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetOrderId() {
        return this.orderId;
    }

    @JsonIgnore
    public String getOrderId() {
        return (String)OptionalNullable.getFrom(this.orderId);
    }

    @JsonGetter(value="line_item_uid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetLineItemUid() {
        return this.lineItemUid;
    }

    @JsonIgnore
    public String getLineItemUid() {
        return (String)OptionalNullable.getFrom(this.lineItemUid);
    }

    @JsonGetter(value="reference_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetReferenceId() {
        return this.referenceId;
    }

    @JsonIgnore
    public String getReferenceId() {
        return (String)OptionalNullable.getFrom(this.referenceId);
    }

    @JsonGetter(value="buyer_payment_instrument_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetBuyerPaymentInstrumentIds() {
        return this.buyerPaymentInstrumentIds;
    }

    @JsonIgnore
    public List<String> getBuyerPaymentInstrumentIds() {
        return (List)OptionalNullable.getFrom(this.buyerPaymentInstrumentIds);
    }

    public int hashCode() {
        return Objects.hash(this.amountMoney, this.orderId, this.lineItemUid, this.referenceId, this.buyerPaymentInstrumentIds);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GiftCardActivityActivate)) {
            return false;
        }
        GiftCardActivityActivate other = (GiftCardActivityActivate)obj;
        return Objects.equals(this.amountMoney, other.amountMoney) && Objects.equals(this.orderId, other.orderId) && Objects.equals(this.lineItemUid, other.lineItemUid) && Objects.equals(this.referenceId, other.referenceId) && Objects.equals(this.buyerPaymentInstrumentIds, other.buyerPaymentInstrumentIds);
    }

    public String toString() {
        return "GiftCardActivityActivate [amountMoney=" + this.amountMoney + ", orderId=" + this.orderId + ", lineItemUid=" + this.lineItemUid + ", referenceId=" + this.referenceId + ", buyerPaymentInstrumentIds=" + this.buyerPaymentInstrumentIds + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().amountMoney(this.getAmountMoney());
        builder.orderId = this.internalGetOrderId();
        builder.lineItemUid = this.internalGetLineItemUid();
        builder.referenceId = this.internalGetReferenceId();
        builder.buyerPaymentInstrumentIds = this.internalGetBuyerPaymentInstrumentIds();
        return builder;
    }

    public static class Builder {
        private Money amountMoney;
        private OptionalNullable<String> orderId;
        private OptionalNullable<String> lineItemUid;
        private OptionalNullable<String> referenceId;
        private OptionalNullable<List<String>> buyerPaymentInstrumentIds;

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder orderId(String orderId) {
            this.orderId = OptionalNullable.of((Object)orderId);
            return this;
        }

        public Builder unsetOrderId() {
            this.orderId = null;
            return this;
        }

        public Builder lineItemUid(String lineItemUid) {
            this.lineItemUid = OptionalNullable.of((Object)lineItemUid);
            return this;
        }

        public Builder unsetLineItemUid() {
            this.lineItemUid = null;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = OptionalNullable.of((Object)referenceId);
            return this;
        }

        public Builder unsetReferenceId() {
            this.referenceId = null;
            return this;
        }

        public Builder buyerPaymentInstrumentIds(List<String> buyerPaymentInstrumentIds) {
            this.buyerPaymentInstrumentIds = OptionalNullable.of(buyerPaymentInstrumentIds);
            return this;
        }

        public Builder unsetBuyerPaymentInstrumentIds() {
            this.buyerPaymentInstrumentIds = null;
            return this;
        }

        public GiftCardActivityActivate build() {
            return new GiftCardActivityActivate(this.amountMoney, this.orderId, this.lineItemUid, this.referenceId, this.buyerPaymentInstrumentIds);
        }
    }
}

