/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.Objects;

public class GiftCardActivityAdjustIncrement {
    private final Money amountMoney;
    private final String reason;

    @JsonCreator
    public GiftCardActivityAdjustIncrement(@JsonProperty(value="amount_money") Money amountMoney, @JsonProperty(value="reason") String reason) {
        this.amountMoney = amountMoney;
        this.reason = reason;
    }

    @JsonGetter(value="amount_money")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonGetter(value="reason")
    public String getReason() {
        return this.reason;
    }

    public int hashCode() {
        return Objects.hash(this.amountMoney, this.reason);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GiftCardActivityAdjustIncrement)) {
            return false;
        }
        GiftCardActivityAdjustIncrement other = (GiftCardActivityAdjustIncrement)obj;
        return Objects.equals(this.amountMoney, other.amountMoney) && Objects.equals(this.reason, other.reason);
    }

    public String toString() {
        return "GiftCardActivityAdjustIncrement [amountMoney=" + this.amountMoney + ", reason=" + this.reason + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.amountMoney, this.reason);
        return builder;
    }

    public static class Builder {
        private Money amountMoney;
        private String reason;

        public Builder(Money amountMoney, String reason) {
            this.amountMoney = amountMoney;
            this.reason = reason;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public GiftCardActivityAdjustIncrement build() {
            return new GiftCardActivityAdjustIncrement(this.amountMoney, this.reason);
        }
    }
}

