/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class GiftCardActivityRefund {
    private final OptionalNullable<String> redeemActivityId;
    private final Money amountMoney;
    private final OptionalNullable<String> referenceId;
    private final String paymentId;

    @JsonCreator
    public GiftCardActivityRefund(@JsonProperty(value="redeem_activity_id") String redeemActivityId, @JsonProperty(value="amount_money") Money amountMoney, @JsonProperty(value="reference_id") String referenceId, @JsonProperty(value="payment_id") String paymentId) {
        this.redeemActivityId = OptionalNullable.of((Object)redeemActivityId);
        this.amountMoney = amountMoney;
        this.referenceId = OptionalNullable.of((Object)referenceId);
        this.paymentId = paymentId;
    }

    protected GiftCardActivityRefund(OptionalNullable<String> redeemActivityId, Money amountMoney, OptionalNullable<String> referenceId, String paymentId) {
        this.redeemActivityId = redeemActivityId;
        this.amountMoney = amountMoney;
        this.referenceId = referenceId;
        this.paymentId = paymentId;
    }

    @JsonGetter(value="redeem_activity_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetRedeemActivityId() {
        return this.redeemActivityId;
    }

    @JsonIgnore
    public String getRedeemActivityId() {
        return (String)OptionalNullable.getFrom(this.redeemActivityId);
    }

    @JsonGetter(value="amount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonGetter(value="reference_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetReferenceId() {
        return this.referenceId;
    }

    @JsonIgnore
    public String getReferenceId() {
        return (String)OptionalNullable.getFrom(this.referenceId);
    }

    @JsonGetter(value="payment_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaymentId() {
        return this.paymentId;
    }

    public int hashCode() {
        return Objects.hash(this.redeemActivityId, this.amountMoney, this.referenceId, this.paymentId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GiftCardActivityRefund)) {
            return false;
        }
        GiftCardActivityRefund other = (GiftCardActivityRefund)obj;
        return Objects.equals(this.redeemActivityId, other.redeemActivityId) && Objects.equals(this.amountMoney, other.amountMoney) && Objects.equals(this.referenceId, other.referenceId) && Objects.equals(this.paymentId, other.paymentId);
    }

    public String toString() {
        return "GiftCardActivityRefund [redeemActivityId=" + this.redeemActivityId + ", amountMoney=" + this.amountMoney + ", referenceId=" + this.referenceId + ", paymentId=" + this.paymentId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().amountMoney(this.getAmountMoney()).paymentId(this.getPaymentId());
        builder.redeemActivityId = this.internalGetRedeemActivityId();
        builder.referenceId = this.internalGetReferenceId();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> redeemActivityId;
        private Money amountMoney;
        private OptionalNullable<String> referenceId;
        private String paymentId;

        public Builder redeemActivityId(String redeemActivityId) {
            this.redeemActivityId = OptionalNullable.of((Object)redeemActivityId);
            return this;
        }

        public Builder unsetRedeemActivityId() {
            this.redeemActivityId = null;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = OptionalNullable.of((Object)referenceId);
            return this;
        }

        public Builder unsetReferenceId() {
            this.referenceId = null;
            return this;
        }

        public Builder paymentId(String paymentId) {
            this.paymentId = paymentId;
            return this;
        }

        public GiftCardActivityRefund build() {
            return new GiftCardActivityRefund(this.redeemActivityId, this.amountMoney, this.referenceId, this.paymentId);
        }
    }
}

