/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.Objects;

public class GiftCardActivityTransferBalanceFrom {
    private final String transferToGiftCardId;
    private final Money amountMoney;

    @JsonCreator
    public GiftCardActivityTransferBalanceFrom(@JsonProperty(value="transfer_to_gift_card_id") String transferToGiftCardId, @JsonProperty(value="amount_money") Money amountMoney) {
        this.transferToGiftCardId = transferToGiftCardId;
        this.amountMoney = amountMoney;
    }

    @JsonGetter(value="transfer_to_gift_card_id")
    public String getTransferToGiftCardId() {
        return this.transferToGiftCardId;
    }

    @JsonGetter(value="amount_money")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    public int hashCode() {
        return Objects.hash(this.transferToGiftCardId, this.amountMoney);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GiftCardActivityTransferBalanceFrom)) {
            return false;
        }
        GiftCardActivityTransferBalanceFrom other = (GiftCardActivityTransferBalanceFrom)obj;
        return Objects.equals(this.transferToGiftCardId, other.transferToGiftCardId) && Objects.equals(this.amountMoney, other.amountMoney);
    }

    public String toString() {
        return "GiftCardActivityTransferBalanceFrom [transferToGiftCardId=" + this.transferToGiftCardId + ", amountMoney=" + this.amountMoney + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.transferToGiftCardId, this.amountMoney);
        return builder;
    }

    public static class Builder {
        private String transferToGiftCardId;
        private Money amountMoney;

        public Builder(String transferToGiftCardId, Money amountMoney) {
            this.transferToGiftCardId = transferToGiftCardId;
            this.amountMoney = amountMoney;
        }

        public Builder transferToGiftCardId(String transferToGiftCardId) {
            this.transferToGiftCardId = transferToGiftCardId;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public GiftCardActivityTransferBalanceFrom build() {
            return new GiftCardActivityTransferBalanceFrom(this.transferToGiftCardId, this.amountMoney);
        }
    }
}

